/* <nage04.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library e04 Chapter
 *
 * Mark 4 re-issue, 1996.
 * Mark 5 revised. IER-2148 (Feb 1998).
 * Mark 6 revised. IER-3030 (July 2000).
 */
#ifndef NAGE04
#define NAGE04

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
  /* This header file uses the type FILE,  hence stdio.h has to be 
   * included.
   */
#include <stdio.h>
  /* Message codes and extern of message list */
//#include <nag_e04mesg.h>
#include "nag_e04mesg.h"    //Cheney 2006-6-5
  /* Also note that
   * a) e04uc0 is old e04ucj
   * b) e04uc1 is old e04uck
   */
  /* begin proto */
  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04abc(NAG_E04ABC_FUN funct, double e1, double e2, double *a,
                       double *b, Integer max_fun, double *x,
                       double *f, Nag_Comm *comm, NagError *fail);
  extern void e04abz_f(double eps, double t, double eta, double sftbnd,
                       double xlamda, double *u, double *fu, double gu,
                       double *xmin, double *fmin, double *xw, double *fw,
                       double *xv, double *fv, double *a, double *fa,
                       double *b, double *oldf, double *b1, double *scxbd,
                       double *e, double *d, double *rr, double *ss,
                       double *gtest1, double *gtest2, double *tol, Integer *iloc,
                       Integer *itest);
  extern void e04abz(double eps, double t, double eta,
                     double sftbnd, double xlamda, double *u,
                     double *fu, double gu, double *xmin, double *fmin,
                     double *xw, double *fw, double *xv, double *fv,
                     double *a, double *fa, double *b, double *oldf,
                     double *b1, double *scxbd, double *e, double *d,
                     double *rr, double *ss, double *gtest1, double *gtest2,
                     double *tol, int *iloc, int *itest);
  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04bbc(NAG_E04BBC_FUN funct, double e1, double e2, double *a,
                       double *b, Integer max_fun, double *x,
                       double *f, double *g, Nag_Comm *comm, NagError *fail);
  extern void e04bbz(double eps, double t, double eta,
                     double xlamda, double *u, double *fu, 
                     double *gu, double *xmin, 
                     double *fmin, double *gmin,
                     double *xw, double *fw, 
                     double *gw, double *a,
                     double *b, double *oldf, 
                     double *b1, double *scxbd,
                     double *e, double *d, double *rr,
                     double *ss, double *gtest1, 
                     double *gtest2, double *tol,
                     int *iloc, int *itest);
  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04ccc(Integer n, NAG_E04CCC_FUN funct, double *x, 
                       double *fmin, Nag_E04_Opt *options,
                       Nag_Comm *user_comm, NagError *fail);
  extern void e04ccz(Integer n, double xc[], double fmin, double fmax, 
                     double simplex[], Nag_E04_Opt *opt, 
                     Nag_FileSt *stream,
                     Nag_Comm *comm);
  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04dgc(Integer n, NAG_E04DGC_FUN objfun, double x[], 
                       double *objf, double grad[],
                       Nag_E04_Opt *options, 
                       Nag_Comm *user_comm, NagError *fail);
  extern void e04dgt(Nag_PrintType print_level, double alfa, double objf,
                     double gnorm, double objgrd[], double x[],
                     double xnorm, double xkxknm, Integer n, Integer inform,
                     Nag_E04_Opt *opt, Nag_FileSt *stream, Nag_Comm *comm);
  extern void e04dgu(Boolean debug, Integer debug_iter, Integer iter,
                     Boolean needfd, NAG_E04DGC_FUN objfun,
                     Integer n, double *alfbnd, double alfmax,
                     double *epsaf, double epsrf, double eta,
                     double dxnorm, double xnorm, double dx[],
                     double *alfa, double *objf, double *gdx,
                     double grad[], double x[], Integer *inform,
                     Integer *nfun, double ugrad[], double x1[],
                     Nag_Comm *comm);
  extern Boolean e04dgv(double objf, double oldf, double alfa, double pnorm,
                        double  rtftol, double cubert, double ftol, double xnorm,
                        double gnorm, double epsaf);
  extern double e04dgw(double objf, double fguess, double gtp, double smax);
  extern void e04dgx(Integer n, double gamma_, double sj[],
                     double hjv[], double hjyj[], double yjsj,
                     double yjhyj, double vsj, double vhyj,
                     double hjp1v[], Integer iter, Boolean debug,
                     Integer debug_iter);
  extern void e04dgy(Integer n, double hnew[], double hold[],
                     double alpha, double pk[], double yk[],
                     double g[], Integer iter, Boolean debug,
                     Integer debug_iter);
  extern void e04dgz(Integer n, double x[], double *xnorm,
                     NAG_E04DGC_FUN objfun,
                     Integer max_iter,
                     double max_line_step, Integer *inform, double *optim_tol,
                     double f_prec, double *objf, Integer debug_iter,
                     Nag_PrintType print_level,
                     double linesearch_tol, Boolean debug, double f_est,
                     double sk[], double yk[], double diagb[], double olddb[],
                     double sr[], double yr[], double oldg[], double hg[],
                     double hyk[], double pk[], double hyr[],
                     double wx[], double g[], double wgrad[],
                     Nag_E04_Opt *opt, Nag_FileSt *stream, Nag_Comm *comm);
  extern NAG_DLL_EXPIMP void NAG_CALL e04fcc(Integer m, Integer n, NAG_E04FCC_FUN lsqfun,
                                             double x[], double *fsumsq, double fvec[],
                                             double fjac[], Integer tdj,
                                             Nag_E04_Opt *options, Nag_Comm *user_comm, NagError *fail);
  extern void e04fch(Integer m, Integer n, double xc[],
                     double fvecc[], double fjacc[], Integer tdj,
                     double g[], double alpha, double xk_norm,
                     Nag_E04_Opt opt, Nag_FileSt *stream, Nag_Comm *comm);
  extern void e04fcv(Integer m, Integer n, Nag_Fun *fcall,
                     double eps, double t,
                     double eta, double sftbnd, double xlamda,
                     double p[], double gtp, double x[],
                     double *f, double *alpha, double fjac[],
                     Integer tdj, double fvec[], double g[], Integer *numf,
                     Integer *flag, double w[], Nag_Comm *comm);
  extern void e04fcw(Integer m, Integer n, NAG_E04FCC_FUN lsfun,
                     double x[], double fvec[], double fjac[], Integer tdj,
                     Nag_Comm *comm);
  extern void e04fcx(Integer m, Integer n, NAG_E04FCC_FUN lsfun,
                     double x[], double fvec[], double fjac[], Integer tdj,
                     Nag_Comm *comm);
  extern void e04fcy(Integer m, Integer n, Integer ns, double epsmch,
                     Nag_Fun *fcall, Integer grade, double x[],
                     double fvec[], double ff, Boolean p1zero,
                     double v[], Integer tdv, double p[], double phesl[],
                     double phesd[], double rhs[],
                     double w[], Nag_Comm *comm);
  extern void e04fcz(Integer m, Integer n, Nag_Fun *fcall,
                     Nag_PrintType print_level, Integer max_iter, double eta,
                     double xtol, double stepmx, double x[],
                     double *fsumsq, double fvec[], double fjac[],
                     Integer tdj, double s[], double vt[], Integer tdvt,
                     Integer *niter, Integer *nftotl, int *error,
                     Nag_E04_Opt *opt, Nag_FileSt *stream, Nag_Comm *comm);
  extern NAG_DLL_EXPIMP void NAG_CALL e04gbc(Integer m, Integer n, NAG_E04GBC_FUN lsqfun,
                                             double x[], double *fsumsq, double fvec[], double fjac[],
                                             Integer tdj, Nag_E04_Opt *options, Nag_Comm *user_comm, NagError *fail);
  extern void e04gbx(Integer m, Integer n, NAG_E04GBC_FUN lsfun,
                     double x[], double fvec[], double fjac[], Integer tdj,
                     Nag_Comm *comm);
  extern void e04gbz(Integer m, Integer n, double h[],
                     double alpha, double p[], double gplus[],
                     double g[], double fjac[], Integer tdj, double w[]);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04gdq(Integer m, Integer n,
                     void (*lsqlin)(Integer m, Integer n, Nag_Fun *fcall,
                                    double eps, double t, double eta, double sftbnd,
                                    double xlamda, double p[], double gtp, double x[],
                                    double *f, double *alpha, double fjac[], Integer tdj,
                                    double fvec[], double g[], Integer *nftotl,
                                    Integer *iflag, double w[], Nag_Comm *comm),
                     Nag_Fun *fcall, double eta, Integer grade, Nag_PrintType print_level,
                     double stepmx, double epsmch, double *tau, double xnorm,
                     Boolean *nomove, double x[], double fvec[],
                     double fjac[], Integer tdj, double g[], double p[],
                     double *alpha, double *pnorm,
                     double *ssqnew, double *ssqold, Integer *niter,
                     Integer *nftotl, Integer *nwhy, double w[],
                     Nag_E04_Opt *opt, Nag_FileSt *stream, Nag_Comm *comm);*/
  extern void e04gdq(Integer m, Integer n,
                     NAG_E04GDQ_FUN lsqlin,
                     Nag_Fun *fcall, double eta, Integer grade, Nag_PrintType print_level,
                     double stepmx, double epsmch, double *tau, double xnorm,
                     Boolean *nomove, double x[], double fvec[],
                     double fjac[], Integer tdj, double g[], double p[],
                     double *alpha, double *pnorm,
                     double *ssqnew, double *ssqold, Integer *niter,
                     Integer *nftotl, Integer *nwhy, double w[],
                     Nag_E04_Opt *opt, Nag_FileSt *stream, Nag_Comm *comm);
  extern void e04gdr(Integer m, Integer n, double a[], Integer tda,
                     double x[], double y[]);
  extern void e04gds(Integer ns, Integer grade, double epsmch, double utf[],
                     double s[], double phesl[], double phesd[],
                     double rhs[], Integer *nphi);
  extern void e04gdu(double s[], Integer *rank);
  extern void e04gdv(Integer n, double a[], Integer tda);
  extern void e04gdw(Integer maxrnk, double s[], Integer *rank);
  extern void e04gdx(int *flag, Integer m, Integer n, double fjac[],
                     Integer tdj, double vt[], Integer lvt, double fvec[],
                     double s[], Boolean wantvc, double utf[],
                     double w[]);
  extern void e04gdy(Integer m, Integer n, Integer *maxrnk, Integer *grade,
                     Integer *nwhy, double tau, double epsmch,
                     double fvec[], double fjac[], Integer tdj,
                     double s[], double vt[], Integer tdv, double utf[],
                     Boolean *gauss, Boolean nomove, double *w);
  extern void e04gdz(Integer m, Integer n, Nag_Fun *fcall,
                     Integer max_iter, double eta,
                     double xtol, double stepmx, double x[],
                     double *ssqnew, double fvec[], double fjac[],
                     Integer tdj, Integer lvt, Integer *niter, Integer *nftotl,
                     Integer *nwhy, double *rteps, double *rtol,
                     double *tol, Integer *grade,
                     double *peps, double g[], double *ssqold,
                     Boolean *gauss, double *tau, double *alpha, double *pnorm,
                     double *epsmch, Boolean *nomove, Boolean deriv_check, Nag_Comm *comm);
  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04hbc(Integer n, NAG_E04HBC_FUN sfun, double x[], 
                       double delta[], double hesd[],
                       double *f, double g[], 
                       Nag_Comm *user_comm, NagError *fail);
  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04hcc(Integer n, NAG_E04HCC_FUN sfun, double x[], 
                       double *f, double g[], 
                       Nag_Comm *user_comm, NagError *fail);
  extern void e04hcz(Integer n, double y[], double z[]);
  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04hdc(Integer n, NAG_E04LBC_FUN sfun, NAG_E04LBC_HESS shess,
                       double x[], double g[], double hesl[], double hesd[], 
                       Nag_Comm *user_comm, NagError *fail);
  extern void e04hdz(Integer n, Integer lh,  double hesl[], double hesd[],
                     double p[], double w[], double *y);
  extern void e04hev(Integer m, Integer n, Nag_Fun *fcall,
                     double eps, double t, double eta, double sftbnd,
                     double xlamda, double p[], double gtp, double x[],
                     double *f, double *alpha, double fjac[],
                     Integer tdj, double fvec[], double g[], Integer *numf,
                     Integer *flag, double w[], Nag_Comm *comm);
  extern void e04hey(Integer n, Integer ns, Integer grade,
                     double v[], Integer tdv, double p[],
                     double phesl[], double phesd[], double prhs[],
                     double h[], double w[]);
  extern void e04hez(Integer m, Integer n, double fvec[], double fjac[],
                     Integer tdj, double g[]);
  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04jbc(Integer n, NAG_E04JBC_FUN sfun, Nag_BoundType bound, 
                       double bl[], double bu[],
                       double x[], double *f, 
                       double g[], Nag_E04_Opt *options, 
                       Nag_Comm *user_comm, NagError *fail);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04jbg(Integer n, NAG_E04JBC_FUN sfun,
                     Nag_PrintType print_level, Boolean locsch, int intyp,
                     void (*minlin)(Integer n, NAG_E04JBC_FUN sfun,
                                    double eps, double t,
                                    double eta, double sftbnd, double xlamda,
                                    double p[], double gtp, double x[],
                                    double *f, double *alpha, double g[],
                                    Integer *nftotl, Integer *iflag, Nag_Comm *comm),
                     Integer max_iter, double eta,
                     double xtol, double stepmx, double fest,
                     double delta[], int ibound, double bl[],
                     double bu[], double x[], double hesl[],
                     double hesd[], Integer istate[], double *f,
                     double g[], Nag_E04_Opt *opt, Nag_FileSt *stream, Nag_Comm *comm,
                     char error_buf[], int *error);*/
  extern void e04jbg(Integer n, NAG_E04JBC_FUN sfun,
                     Nag_PrintType print_level, Boolean locsch, int intyp,
                     NAG_E04JBG_FUN minlin,
                     Integer max_iter, double eta,
                     double xtol, double stepmx, double fest,
                     double delta[], int ibound, double bl[],
                     double bu[], double x[], double hesl[],
                     double hesd[], Integer istate[], double *f,
                     double g[], Nag_E04_Opt *opt, Nag_FileSt *stream, Nag_Comm *comm,
                     char error_buf[], int *error);
  extern void e04jbh(Integer n, double xc[], double f,
                     double g[], double gpjnorm, double cond,
                     double alpha, double xk_norm,
                     Nag_E04_Opt opt, Nag_FileSt *stream, Nag_Comm *comm);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04jbm(Integer n, Integer *nfree, int ibound,
                     double delta[], double rtolsq, double toleps,
                     double endeps, double stepmx, double sfirst,
                     NAG_E04JBC_FUN sfun, 
                     void (*minlin)(Integer n, NAG_E04JBC_FUN sfun,
                                    double eps, double t,
                                    double eta, double sftbnd, double xlamda,
                                    double p[], double gtp, double x[],
                                    double *f, double *alpha, double g[],
                                    Integer *nftotl, Integer *iflag, Nag_Comm *comm),
                     double x[], double bl[], double bu[], double *f,
                     Integer istate[], double g[], double *gtg,
                     Integer *itype, double gpj[], double *alpha, double p[],
                     double hesl[], Integer *lhproj,
                     double hesd[], double *boundk, Integer *nftotl,
                     Integer *lcount, int *error, Boolean *finish,
                     double w[], Nag_Comm *comm);*/
  extern void e04jbm(Integer n, Integer *nfree, int ibound,
                     double delta[], double rtolsq, double toleps,
                     double endeps, double stepmx, double sfirst,
                     NAG_E04JBC_FUN sfun, 
                     NAG_E04JBM_FUN minlin,
                     double x[], double bl[], double bu[], double *f,
                     Integer istate[], double g[], double *gtg,
                     Integer *itype, double gpj[], double *alpha, double p[],
                     double hesl[], Integer *lhproj,
                     double hesd[], double *boundk, Integer *nftotl,
                     Integer *lcount, int *error, Boolean *finish,
                     double w[], Nag_Comm *comm);
  extern void e04jbn(Integer n, Integer istate[], double *f,
                     double x[], double delta[],
                     NAG_E04JBC_FUN sfun,
                     Integer *itype, Integer *nftotl, double g[],
                     double fplus[], double fminus[], Nag_Comm *comm);
  extern void e04jbp(Integer n, double x[], double delta[],
                     double *delmin, Integer *flag);
  extern void e04jbq(Integer n, NAG_E04JBC_FUN sfun,
                     double eps, double t,
                     double eta, double sftbnd, double xlamda,
                     double p[], double gtp, double x[],
                     double *f, double *alpha, double g[],
                     Integer *nftotl, Integer *iflag, Nag_Comm *comm);
  extern void e04jbr(Integer nfree, Integer jfix, double *gtp,
                     double pa[], double gpjold[]);
  extern void e04jbs(Integer n, double tol, Integer *nfree,
                     Integer istate[], double x[], double bl[], double bu[],
                     double p[], Integer *jfix, double *boundk,
                     Boolean *recalc);
  extern double e04jbt(double fnew, double fm, double gtp, double smax);
  extern void e04jbu(Integer nfrnew, Integer jfix, double hesl[],
                     double hesd[], Integer *lhproj,
                     double w[], Integer *iflag);
  extern void e04jbv(Integer n, Integer *nfree, double *stepmx,
                     double test, double tol, Integer istate[],
                     double x[], double bl[], double bu[], double p[],
                     Integer *jfix, double *boundk);
  extern double e04jbw(Integer lhd);
  extern void e04jbx(Integer lhd, double hesd[], Integer n,
                     double hesl[], double *cond);
  extern void e04jby(Integer n, Integer nfree, Integer istate[], double g[],
                     double gproj[], double *gtg);
  extern void e04jbz(Integer n, double eps, double x[], double bl[],
                     double bu[], Integer *nfree, Integer *nequal,
                     Integer istate[], int *intype);
  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04kbc(Integer n, NAG_E04KBC_FUN sfun, Nag_BoundType bound, 
                       double bl[], double bu[],
                       double x[], double *f, 
                       double g[], Nag_E04_Opt *options, 
                       Nag_Comm *user_comm, NagError *fail);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04kbg(Integer n, NAG_E04KBC_FUN sfun,
                     Nag_PrintType print_level, Boolean locsch, Integer intyp,
                     void (*minlin)(Integer n, NAG_E04KBC_FUN sfun,
                                    double eps, double t,
                                    double eta, double sftbnd, double xlamda,
                                    double p[], double gtp, double x[],
                                    double *f, double *alpha, double g[],
                                    Integer *numf, Integer *iflag, Nag_Comm *comm),
                     Integer max_iter, double eta,
                     double xtol, double stepmx, double fest,
                     int ibound, double bl[],
                     double bu[], double x[], double hesl[],
                     double hesd[], Integer istate[], double *f,
                     double g[], Nag_E04_Opt *opt, Nag_FileSt *stream, Nag_Comm *comm, int *error);*/
   extern void e04kbg(Integer n, NAG_E04KBC_FUN sfun,
                     Nag_PrintType print_level, Boolean locsch, Integer intyp,
                     NAG_E04KBG_FUN minlin,
                     Integer max_iter, double eta,
                     double xtol, double stepmx, double fest,
                     int ibound, double bl[],
                     double bu[], double x[], double hesl[],
                     double hesd[], Integer istate[], double *f,
                     double g[], Nag_E04_Opt *opt, Nag_FileSt *stream, Nag_Comm *comm, int *error); 
   //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04kbp(Integer n, Integer *nfree, double fm,
                     double rtolsq, double toleps, double endeps,
                     double stepmx, double sfirst, NAG_E04KBC_FUN sfun,
                     void (*minlin)(Integer n, NAG_E04KBC_FUN sfun,
                                    double eps, double t,
                                    double eta, double sftbnd, double xlamda,
                                    double p[], double gtp, double x[],
                                    double *f, double *alpha, double g[],
                                    Integer *nftotl, Integer *iflag, Nag_Comm *comm),
                     double x[], double bl[],
                     double bu[], double *f, Integer istate[],
                     double g[], double *gtg, double gpj[],
                     double p[], double hesl[], Integer *lhproj,
                     double hesd[], double *boundk, Integer *nftotl,
                     Integer *lcount, int *error, Boolean *finish,
                     double w[], Nag_Comm *comm);*/
  extern void e04kbp(Integer n, Integer *nfree, double fm,
                     double rtolsq, double toleps, double endeps,
                     double stepmx, double sfirst, NAG_E04KBC_FUN sfun,
                     NAG_E04KBP_FUN minlin,
                     double x[], double bl[],
                     double bu[], double *f, Integer istate[],
                     double g[], double *gtg, double gpj[],
                     double p[], double hesl[], Integer *lhproj,
                     double hesd[], double *boundk, Integer *nftotl,
                     Integer *lcount, int *error, Boolean *finish,
                     double w[], Nag_Comm *comm);
  extern void e04kbq(Integer n, double z[], double hesd[],
                     double hesl[], double p[]);
  extern void e04kbr(Integer n, double alpha, double z[],
                     double hesd[], double hesl[], Integer *flag);
  extern void e04kbs(Integer n, double z[], double bl[], double bu[],
                     Integer istate[], double p[], double ztemp[],
                     double *spos, double *sneg);
  extern void e04kbt(Integer n, Integer nfree, double *step,
                     double bl[], double bu[], Integer istate[],
                     double y[], double p[], double *spos,
                     double *sneg, Integer *flag);
  extern void e04kbu(Integer n, Integer nfree,
                     double eps, double x[], double bl[], double bu[],
                     Integer istate[], NAG_E04JBC_FUN sfun,
                     double *step, double *fnew, Integer *nfun, double p[], double y[],
                     double gy[], Integer *is, Integer *ifail, Nag_Comm *comm);
  extern void e04kbv(Integer inew, double g[], Integer *nfree,
                     Integer istate[], double gproj[], double *gtg,
                     double hesd[], Integer *lhproj, double *boundk,
                     double *cond);
  extern void e04kbw(Integer n, Integer *numneg, Integer *nftotl,
                     NAG_E04JBC_FUN sfun,
                     double f, double x[], Integer istate[],
                     double gtemp[], Integer *izero, Nag_Comm *comm);
  extern void e04kbx(Integer n, Integer nfree, double tol,
                     Integer istate[], double g[], Boolean *lm1pos,
                     Integer *ineglm, Integer *numneg);
  extern void e04kby(Integer m, double step, double goldtp,
                     double gold[], double gnewtp, double gnew[],
                     double y[], double z[], double hesd[], double hesl[],
                     Integer *flag);
  extern void e04kbz(Integer n, double boundk, double hesd[], double *cond);
  extern void e04lbb(Integer n, Integer lel, Integer is,  double el[],
                     double p[]);
  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04lbc(Integer n, NAG_E04LBC_FUN sfun, NAG_E04LBC_HESS shess,
                       Nag_BoundType bound, double bl[], double bu[], 
                       double x[], double *f, double g[], Nag_E04_Opt *options,
                       Nag_Comm *user_comm, NagError *fail);
  extern void e04lbd(Integer n, Integer lel,  double el[], double b[],
                     double y[]);
  extern void e04lbe(Integer n, double xc[], double f,
                     double g[], double gpjnorm, double cond, Boolean posdef,
                     double alpha, double xk_norm,
                     Nag_E04_Opt opt, Nag_FileSt *stream, Nag_Comm *comm);
  extern void e04lbg(Integer n, Integer *nfree, Integer *numneg,
                     Integer *nftotl,  Boolean *nomove, Boolean userh,
                     NAG_E04LBC_HESS shess,
                     double eps, double delta,
                     double bl[], double bu[],
                     NAG_E04LBC_FUN sfun,
                     double *f, double x[],  Integer istate[],
                     double gfull[], double gproj[], double hdfull[],
                     double hdproj[], double hlfull[],  Integer nh,
                     double hlproj[],  Integer lh, Integer *lhproj, Integer *iq,
                     Integer *izero,  Boolean *tight, Nag_Comm *comm);
  extern void e04lbh(Integer n, Integer inew,  Boolean *tight,  Integer istate[],
                     Integer *nfree);
  extern void e04lbj(Integer n, Integer nfree,  double tol,  Boolean lsfail,
                     Boolean tight,  Integer istate[],  double g[],
                     double p[], double hesl[],  Integer lh,
                     Boolean *lm2pos,  Integer *ineglm, Integer *numneg);
  extern void e04lbk(Integer n, Integer klm,  double *total, double bndsgn,
                     Integer istate[],  double hesl[],  Integer lh,
                     double p[]);
  extern void e04lbl(Integer n, Integer *nfree,  double tol,  Integer istate[],
                     double x[], double bl[], double bu[], double p[],
                     Boolean *recalc);
  extern void e04lbm(Integer n,  double *stepmx, double tol, double x[],
                     double bl[], double bu[], double p[]);
  extern void e04lbn(Integer n, Integer nfree, Integer inew, Integer istate[],
                     double gfull[], double hdfull[], double hlfull[],
                     Integer nh,  double gproj[], double hdproj[],
                     double hlproj[],  Integer lh,  double *delta,
                     Integer *nsphi, Integer *lhproj,  double w[]);
  extern void e04lbp(Integer n, Integer lh,  double x[],
                     double g[],  Integer istate[],
                     NAG_E04LBC_FUN sfun,
                     double delta, double hesl[], double hesd[], Nag_Comm *comm);
  extern void e04lbq(Integer n, Integer lh,  double x[],
                     double g[],  Integer istate[], Integer inew,
                     NAG_E04LBC_FUN sfun,
                     double delta, double hesl[],
                     double hesd[], Nag_Comm *comm);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04lbr(Integer n,
                     NAG_E04LBC_FUN sfun,
                     NAG_E04LBC_HESS shess,
                     Boolean userh,
                     Nag_PrintType print_level,
                     void (*minlin) (Integer n,
                                     NAG_E04LBC_FUN sfun,
                                     double eps, double t,
                                     double eta, double sftbnd, double xlamda,
                                     double p[], double gtp, double x[], double *f,
                                     double *alpha, double g[],  Integer *nftotl,
                                     Integer *iflag, Nag_Comm *comm),
                     Integer maxiter,  double eta, double xtol,
                     double delta, double stepmx,  Integer ibound,
                     double bl[], double bu[], double x[],
                     double hesl[],  Integer lh,  double hesd[],
                     Integer istate[],  double *f, double g[], Nag_E04_Opt *opt,
                     Nag_FileSt *stream, Nag_Comm *comm,
                     Integer *ifail);*/
  extern void e04lbr(Integer n,
                     NAG_E04LBC_FUN sfun,
                     NAG_E04LBC_HESS shess,
                     Boolean userh,
                     Nag_PrintType print_level,
                     NAG_E04LBR_FUN minlin,
                     Integer maxiter,  double eta, double xtol,
                     double delta, double stepmx,  Integer ibound,
                     double bl[], double bu[], double x[],
                     double hesl[],  Integer lh,  double hesd[],
                     Integer istate[],  double *f, double g[], Nag_E04_Opt *opt,
                     Nag_FileSt *stream, Nag_Comm *comm,
                     Integer *ifail);
  extern void e04lbs(Integer n, NAG_E04KBC_FUN sfun,
                     double eps, double t,
                     double eta, double sftbnd, double xlamda,
                     double p[], double gtp, double x[],
                     double *f, double *alpha, double g[],
                     Integer *nftotl, Integer *iflag, Nag_Comm *comm);
  extern void e04lbt(Integer n, Integer nfree, double tol,
                     Integer istate[], double g[], double rneglm,
                     Integer *ineglm);
  extern void e04lbu(Integer n, Integer *numneg, Integer istate[]);
  extern void e04lbv(Integer n, Integer istate[], double pa[],
                     double signum, double p[]);
  extern void e04lbw(double hesd[], Integer lhd, double boundk,
                     Integer *flag, double *cond);
  extern void e04lbx(Integer n, Integer istate[], double gfull[],
                     double hdfull[], double hlfull[], double gproj[],
                     double hdproj[], double hlproj[], Integer *lhproj);
  extern void e04lby(Integer n, double eps, double x[], double bl[],
                     double bu[], Integer *nfree, Integer istate[],
                     Integer *nequal);
  extern void e04lbz(Integer n, int ibound, double *bndmax,
                     double bl[], double bu[]);
  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04mfc(Integer n, Integer nclin, double a[], 
                       Integer tda, double bl[], double bu[],
                       double cvec[], double x[],
                       double *obj, Nag_E04_Opt *options, 
                       Nag_Comm *user_comm, NagError *fail);
  extern void e04mfg(const char *prbtyp, Integer n, Integer nclin, double a[], Integer tda,
                     double bl[], double bu[], double cvec[], double ax[],
                     double x[], double *obj, double lambda[], Integer istate[],
                     Boolean vertex, Boolean cset, Nag_ae04mf *ae04mf, double w[],
                     Integer iw[], Nag_ee04mf *ee04mf, Nag_E04_Opt *opt, Nag_Comm *comm,
                     Nag_FileSt *stream, NagError *ovflow, Nag_EndState *endstate);
  extern void e04mfh(Integer n, Integer nclin, Integer tda, Integer istate[],
                     double bigbnd, Integer *numinf, double *suminf,
                     double bl[], double bu[], double a[], double featol[],
                     double cvec[], double x[], double wtinf[]);
  extern void e04mfj(Boolean *rowerr, Boolean unitq, Integer nclin,
                     Integer nactiv, Integer nfree, Integer nz, Integer n,
                     Integer tdq, Integer tda, Integer tdt, Integer istate[],
                     Integer kactiv[], Integer kx[], Integer *jmax,
                     double *errmax, double *xnorm, double a[],
                     double ax[], double bl[], double bu[], double featol[],
                     double t[], double x[], double q[], double p[],
                     double work[]);
  extern void e04mfk(Nag_EndState endstate, const char *prbtyp,
                     double obj, Integer numinf,
                     Integer nfree, Integer n,
                     Integer nclin, Integer ncnln, Integer nctotl,
                     double bigbnd, Integer nactiv, Integer istate[],
                     Integer kactiv[], Integer kx[], double ax[], double bl[],
                     double bu[], double c[], double clamda[],
                     double rlamda[], double x[],
                     Nag_E04_Opt *opt, Nag_FileSt *stream, Nag_Comm *comm);
  extern void e04mfl(Integer nrz, Integer nz,
                     double zerolm, Integer *notopt, Integer numinf,
                     double *trusml, double *smllst, Integer *jsmlst,
                     double *tinyst, Integer *jtiny, double gq[], Nag_ee04mf *ee04mf);
  extern void e04mfm(Integer n, Integer tda,
                     Integer tdt, Integer nactiv, Integer nfree, Integer nz,
                     Integer istate[], Integer kactiv[], Integer kx[],
                     double zerolm, Integer *notopt, Integer numinf,
                     double *trusml, double *smllst, Integer *jsmlst,
                     Integer *ksmlst, double *tinyst, Integer *jtiny,
                     Integer jinf, double *trubig, double *biggst,
                     Integer *jbigst, Integer *kbigst, double a[],
                     double anorms[], double gq[], double rlamda[],
                     double t[], double wtinf[], Nag_ee04mf *ee04mf);
  extern void e04mfn(const char *subr, const char *msg, double v[], Integer lenv);
  extern void e04mfq(Integer n, Integer nclin, Integer istate[],
                     double bigbnd, Integer *nviol, Integer *jmax,
                     double *errmax, double ax[], double bl[],
                     double bu[], double featol[], double x[], Nag_ee04mf *ee04mf);
  extern void e04mfr(const char *job, Integer n, Integer nclin,
                     Integer *nmoved, Integer iter, Integer numinf,
                     Integer istate[],
                     double bl[], double bu[], double featol[],
                     double featlu[], double x[], Nag_ce04mf *ce04mf);
  extern void e04mfs(Boolean firstv, Integer n, Integer nclin, Integer istate[],
                     double bigalf, double bigbnd, double pnorm,
                     Boolean *hitlow, Boolean *move, Boolean *onbnd, Boolean *unbndd,
                     double *alfa, double *alfap, Integer *jhit,
                     double anorm[], double ap[], double ax[], double bl[],
                     double bu[], double featol[], double featlu[],
                     double p[], double x[], Nag_ce04mf *ce04mf, Nag_ee04mf *ee04mf);
  extern void e04mft(Nag_Start start, Boolean vertex, Integer nclin,
                     Integer nctotl, Integer *nactiv, Integer *nartif,
                     Integer *nfree, Integer n, Integer tda, Integer istate[],
                     Integer kactiv[], Integer kx[], double bigbnd,
                     double tolact, double a[], double ax[],
                     double bl[], double bu[], double featol[], double x[],
                     double wx[], double work[], Nag_ee04mf *ee04mf);
  extern void e04mfv(Boolean cset, Integer n, Integer nclin, Nag_ae04mf *ae04mf);
  extern void e04mfy(Integer nrz, Integer tdr, double r[], double rzz);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04mfz(const char *prbtyp, char *msg, Boolean cset,
                     Boolean rset, Boolean *unitq,
                     Integer itmax, Integer jinf, Integer *nviol, Integer n,
                     Integer nclin, Integer lda, Integer *nactiv, Integer *nfree,
                     Integer *nrz, Integer *nz, Integer istate[], Integer kactiv[],
                     Integer kx[],
                     void (*print_iter)(const char *prbtyp, Boolean *header, Boolean rset,
                                        Nag_PrintType print_level, Integer isdel, Integer *jdel,
                                        Integer jadd, Integer n, Integer nclin,
                                        Integer nactiv, Integer nfree, Integer nz,
                                        Integer nrz, Integer tdr, Integer tdt, Integer istate[],
                                        double alfa, double condrz, double condt, double drzz,
                                        double grznrm, Integer numinf,
                                        double suminf, Integer notopt, double objqp,
                                        double trusml, double ax[], double r[], double t[],
                                        double x[], Integer kx[], Integer kactive[],
                                        double rlambda[], double gq[], double work[],
                                        Nag_QP_Print *print_inf, Nag_E04_Opt *opt,
                                        Nag_FileSt *stream, Nag_Comm *comm),
                     double *obj, Integer *numinf, double *xnorm, double a[],
                     double ax[], double bl[], double bu[], double cvec[],
                     double featol[], double featlu[], double x[], Nag_E04_Opt *opt,
                     double w[], Nag_de04nb *de04nb, Nag_ae04mf *ae04mf,
                     Nag_ce04mf *ce04mf, Nag_de04mf *de04mf, Nag_QP_Print *print_inf,
                     Nag_FileSt *stream, Nag_Comm *comm, Nag_ee04mf *ee04mf, NagError *ovflow);*/
  extern void e04mfz(const char *prbtyp, char *msg, Boolean cset,
                     Boolean rset, Boolean *unitq,
                     Integer itmax, Integer jinf, Integer *nviol, Integer n,
                     Integer nclin, Integer lda, Integer *nactiv, Integer *nfree,
                     Integer *nrz, Integer *nz, Integer istate[], Integer kactiv[],
                     Integer kx[],
                     NAG_E04MFZ_FUN print_iter,
                     double *obj, Integer *numinf, double *xnorm, double a[],
                     double ax[], double bl[], double bu[], double cvec[],
                     double featol[], double featlu[], double x[], Nag_E04_Opt *opt,
                     double w[], Nag_de04nb *de04nb, Nag_ae04mf *ae04mf,
                     Nag_ce04mf *ce04mf, Nag_de04mf *de04mf, Nag_QP_Print *print_inf,
                     Nag_FileSt *stream, Nag_Comm *comm, Nag_ee04mf *ee04mf, NagError *ovflow);
  extern NAG_DLL_EXPIMP void NAG_CALL e04myc(double **a, Integer **ha, Integer **ka, 
                       double **bl, double **bu, double **xs);
  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04mzc(const char *mps_file, Integer *n, Integer *m, Integer *nnz, 
                       Integer *iobj, double **a, Integer **ha, Integer **ka, 
                       double **bl, double **bu, double **xs,
                       Nag_E04_Opt *options, NagError *fail);
  extern void e04mzg(NAG_E04NKC_HESSFUN_WRAP hx, NAG_E04NKC_HESSFUN hx1, 
                     Integer ngqp, Integer ngobj,
                     Integer ngobj0, Integer nstate,  double *objqp,
                     Integer nka,  double a[],  Integer ha[], Integer ka[],
                     double gobj[], double gobjqp[], double x0[],
                     double x[], double xdif[],  Integer iz[], Integer leniz,
                     double z[],  Integer lenz, Integer iparm[], double rparm[],
                     Nag_Comm *comm);
  extern void e04mzh(NAG_E04NKC_HESSFUN_WRAP hx, NAG_E04NKC_HESSFUN hx1, Boolean gotr, 
                     Boolean incres, Boolean *needpi, Boolean *posdef, Integer lenr, 
                     Integer m, Integer mbs, Integer maxs, Integer n, Integer nb, 
                     Integer ngqp0, Integer ngqp, Integer nnh, Integer *ns, 
                     Integer *jqsave, Integer newsb, Integer *nuncon, double *obj,
                     double *objqp, double featol, double *step, Integer ne, 
                     Integer nka, double a[], Integer ha[], Integer ka[], 
                     Integer hfeas[], Integer hs[], Integer kbs[], double bl[], 
                     double bu[], double blbs[], double bubs[], double gbs[], 
                     double gobjqp[], double rg[], double r[], double hy[], 
                     double xbs[], double xs[], double y[], double y2[], double yq[],
                     Integer iz[], Integer leniz, double z[], Integer lenz,
                     Integer iparm[], double rparm[], 
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  //Cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04mzj(Nag_ProblemType type, NAG_E04NKC_HESSFUN_WRAP hx, 
                     NAG_E04NKC_HESSFUN hx1, Boolean *gotr, Boolean *needlu, 
                     Nag_SparseQP_LU_Type *typelu, Integer lenr, Integer m,
                     Integer maxs, Integer mbs, Integer n, Integer nb, Integer ngqp,
                     Integer ngqp0, Integer ngobj, Integer ngobj0, Integer nnh,
                     Integer *ns, Integer itmax, Integer *itqp, double objadd,
                     double *objqp, Integer iobj, double tolfp, double tolqp, 
                     double tolx, Integer ne, Integer nka, double a[], Integer ha[], 
                     Integer ka[], Integer hfeas[], Integer hs[], Integer kbs[],
                     double ascale[], double b[], Integer lenb, double bl[], 
                     double bu[], double blbs[], double bubs[], double gobj[],
                     double gobjqp[], double gbs[], double pi[], double r[], 
                     double rc[], double rg[], double xbs[], double x0[], 
                     double xs[], double xdif[], Integer iy[], Integer iy2[],
                     double y[], double y2[], double yq[], double t[], 
                     Integer iz[], Integer leniz, double z[], Integer lenz, 
                     Integer iparm[], double rparm[], 
                     Nag_SparseQP_Save_Vars *vsave,
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);*/
  extern void e04mzj(Nag_ProblemType type, NAG_E04NKC_HESSFUN_WRAP hx, 
                     NAG_E04NKC_HESSFUN hx1, Boolean *gotr, Boolean *needlu, 
                     Nag_SparseQP_LU_Type *typelu, Integer lenr, Integer m,
                     Integer maxs, Integer mbs, Integer n, Integer nb, Integer ngqp,
                     Integer ngqp0, Integer ngobj, Integer ngobj0, Integer nnh,
                     Integer *ns, Integer itmax, Integer *itqp, double objadd,
                     double *objqp, Integer iobj, double tolfp, double tolqp, 
                     double tolx, Integer ne, Integer nka, double a[], Integer ha[], 
                     Integer ka[], Integer hfeas[], Integer hs[], Integer kbs[],
                     double ascale[], double b[], Integer lenb, double bl[], 
                     double bu[], double blbs[], double bubs[], double gobj[],
                     double gobjqp[], double gbs[], double dpi[], double r[], 
                     double rc[], double rg[], double xbs[], double x0[], 
                     double xs[], double xdif[], Integer iy[], Integer iy2[],
                     double y[], double y2[], double yq[], double t[], 
                     Integer iz[], Integer leniz, double z[], Integer lenz, 
                     Integer iparm[], double rparm[], 
                     Nag_SparseQP_Save_Vars *vsave,
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  extern void e04mzk(NAG_E04NKC_HESSFUN_WRAP hx, NAG_E04NKC_HESSFUN hx1, Integer *inform, 
                     Integer jq, Integer jradd, Integer lenr, Integer m, Integer mbs, 
                     Integer n, Integer nb, Integer nnh, Integer ns, Integer ne, 
                     Integer nka, double a[],  Integer ha[], Integer ka[], Integer kbs[],
                     double r[], double v[], double w[], double y[], Integer iz[], 
                     Integer leniz, double z[], Integer lenz, 
                     Integer iparm[], double rparm[], Nag_Comm *comm);
  //Cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04mzl(Integer j1_, Integer j2,  Boolean feasbl,  Integer m, Integer n,
                     Integer nng, Integer nng0, Integer ne, Integer nka,
                     double a[],  Integer ha[], Integer ka[], Integer hs[],
                     double g[], double pi[], double rc[],
                     Integer iparm[],  double rparm[]);*/
  extern void e04mzl(Integer j1_, Integer j2,  Boolean feasbl,  Integer m, Integer n,
                     Integer nng, Integer nng0, Integer ne, Integer nka,
                     double a[],  Integer ha[], Integer ka[], Integer hs[],
                     double g[], double dpi[], double rc[],
                     Integer iparm[],  double rparm[]);
  //Cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04mzm(Integer m, Integer nbs, Integer n, Integer ns,
                     double gbs[], double pi[], double rg[],
                     double *rgnorm,  Integer ne, Integer nka,  double a[],
                     Integer ha[], Integer ka[], Integer kbs[], Integer iparm[],
                     double rparm[]);*/
  extern void e04mzm(Integer m, Integer nbs, Integer n, Integer ns,
                     double gbs[], double dpi[], double rg[],
                     double *rgnorm,  Integer ne, Integer nka,  double a[],
                     Integer ha[], Integer ka[], Integer kbs[], Integer iparm[],
                     double rparm[]);
  extern void e04mzn(Boolean *posdef,  Integer *inform, Integer lenr, Integer ns,
                     double *drsq, double r[],  Integer iparm[], double rparm[],
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  //Cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04mzp(Integer m,  double *pinorm, double rhs[],
                     double pi[],  Integer iz[], Integer leniz,  double z[],
                     Integer lenz, Integer iparm[],  double rparm[]);*/
  extern void e04mzp(Integer m,  double *pinorm, double rhs[],
                     double dpi[],  Integer iz[], Integer leniz,  double z[],
                     Integer lenz, Integer iparm[],  double rparm[]);
  extern void e04mzq(Boolean reset_xbs,  Integer *inform, Integer m, Integer n, Integer nb,
                     Integer nbs,  double *rowerr,  Integer ne, Integer nka,
                     double a[],  Integer ha[], Integer ka[],  double b[],
                     Integer lenb, Integer kbs[],  double xbs[], double xs[],
                     double y2[], double y[],  Integer iz[], Integer leniz,
                     double z[],  Integer lenz, Integer iparm[], double rparm[],
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  extern void e04mzr(Boolean *jstfes,  Integer m, Integer mbs, Integer ns,
                     double featol,  Integer hfeas[],  double blbs[],
                     double bubs[], double gbs[], double xbs[],
                     Integer iparm[],  double rparm[],
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  extern void e04nbt(Integer mode, Integer ncolt, Integer n,  double t[],
                     double y[]);
  extern void e04nbu(Integer n, Integer nu, Integer nrank, Integer tdr,
                     Integer i, Integer j,  double r[], double u[],
                     double c[], double s[]);
  extern void e04nbv(Integer n, Integer nu, Integer nrank, Integer tdr,
                     Integer lenv, Integer lenw,  double r[], double u[],
                     double v[], double w[], double c[], double s[]);
  extern void e04nbw(Integer mode, Integer n, Integer nz, Integer nfree,
                     Integer nq, Boolean unitq, Integer kx[], double v[],
                     double zy[], double wrk[]);
  extern void e04nbx(Boolean major, const char *prbtyp, Nag_PrintType print_level,
                     Integer maj_iter, Integer iter, 
                     Integer nfree, Integer nrowa,
                     Integer n, Integer nclin, Integer nctotl, Integer inform,
                     Boolean infeas, double obj, double bigbnd,
                     Integer nactiv, Integer istate[], Integer kactiv[],
                     Integer kx[],  double a[], double bl[], double bu[],
                     double c[], double clamda[], double rlamda[], double featol[], 
                     double x[], Nag_E04_Opt *opt,  Nag_Comm *comm, Nag_FileSt *stream,
                     Nag_Search_State *st, Integer *local_error);
  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04ncc(Integer m, Integer n, Integer nclin, 
                       double a[], Integer tda, double bl[],
                       double bu[], double cvec[], 
                       double b[], double h[], Integer tdh, 
                       Integer kx[], double x[], 
                       double *obj, Nag_E04_Opt *options, 
                       Nag_Comm *user_comm, NagError *fail);
  extern void e04ncg(const char *task,  Boolean unitq,  Integer nfree, Integer n,
                     Integer nrank, Integer tdq, Integer tdr, Integer kx[],
                     double r[], double q[], double v[], double w[], 
                     NagError *fail_qdc);
  extern void e04nch(Boolean linobj, Boolean *rowerr, Boolean unitq,
                     Integer nclin, Integer nactiv, Integer nfree, Integer nrank,
                     Integer nz, Integer n, Integer nctotl, Integer tdzy,
                     Integer tda, Integer tdr, Integer tdt, Integer istate[],
                     Integer kactiv[], Integer kx[], Integer *jmax,
                     double *errmax, double *ctx, double *xnorm,
                     double a[], double ax[], double bl[], double bu[],
                     double cq[], double res[], double res0[],
                     double featol[], double r[], double t[],
                     double x[], double zy[], double p[],
                     double work[], Nag_ce04nc *ce04nc);
  extern void e04ncj(const char *prbtyp, Integer isdel, Integer iter, Integer jadd,
                     Integer jdel, Nag_PrintType print_level, Integer nactiv,
                     Integer nfree,
                     Integer n, Integer nclin, Integer nrank, Integer tdr,
                     Integer tdt, Integer nz, Integer nrz, Integer istate[],
                     double alfa, double condrz, double condt,
                     double gfnorm, double gzrnrm,  Integer numinf,
                     double suminf, double ctx, double ssq,
                     double ax[], double r[], double t[], double x[],
                     double work[], Integer kactiv[], Integer kx[], 
                     double gq[], double rlamda[], Nag_E04_Opt *opt, Nag_Comm *comm, 
                     Nag_Search_State *st, 
                     Nag_QP_Print *print_inf, Nag_FileSt *stream);
  extern void e04nck(Integer n, Integer nactiv,
                     Integer nfree, Integer tda, Integer tdt, Integer numinf,
                     Integer nz, Integer nrz, Integer istate[], Integer kactiv[],
                     Integer kx[],  double dinky,  Integer *jsmlst,
                     Integer *ksmlst, Integer jinf, Integer *jtiny, Integer *jbigst,
                     Integer *kbigst,  double *trulam, double a[],
                     double anorms[], double gq[], double rlamda[],
                     double t[], double wtinf[], Nag_ce04nc *ce04nc);
  extern void e04ncl(Boolean hitcon, Boolean hitlow, Boolean linobj,
                     Boolean unitgz,  Integer nclin, Integer nrank, Integer nrz,
                     Integer n, Integer tdr, Integer jadd, Integer numinf,
                     double alfa, double ctp, double *ctx,
                     double *xnorm, double ap[], double ax[],
                     double bl[], double bu[], double gq[], double nag_hz[],
                     double p[], double res[], double r[], double x[],
                     double work[]);
  extern void e04ncm(Nag_ProblemType prob, Integer n, Integer nclin, Integer *litotl,
                     Integer *lwtotl, Nag_ae04nc *ae04nc, Nag_be04nb *be04nb);
  extern void e04ncp(const char *prbtyp, Boolean linobj, Boolean *singlr, Boolean *unitgz,
                     Boolean unitq,  Integer n, Integer nclin, Integer nfree,
                     Integer lda, Integer ldzy, Integer ldr, Integer nrank,
                     Integer nz, Integer *nrz, Integer istate[], Integer kx[],
                     double bigbnd, double tolrnk,  Integer *numinf,
                     double *suminf, double bl[], double bu[],
                     double a[], double res[], double featol[],
                     double gq[], double cq[], double r[], double x[],
                     double wtinf[], double zy[], double wrk[]);
  extern void e04ncq(Boolean linobj, Boolean singlr, Boolean unitgz,
                     Boolean unitq,  Integer n, Integer nclin, Integer nfree,
                     Integer tda, Integer tdzy, Integer tdr, Integer nrank,
                     Integer numinf, Integer nrz, Integer kx[],  double *ctp,
                     double *pnorm, double a[], double ap[],
                     double res[], double nag_hz[], double p[], double gq[],
                     double cq[], double r[], double zy[],
                     double work[], Nag_ce04nc *ce04nc);
  extern void e04ncr(Integer n, Integer nclin, Integer istate[],
                     double bigbnd, double *cvnorm, double *errmax,
                     Integer *jmax, Integer *nviol,  double ax[], double bl[],
                     double bu[], double featol[], double x[],
                     double work[], Nag_ce04nc *ce04nc);
  extern void e04nct(Boolean unitq,  Integer n, Integer *nactiv, Integer *nfree,
                     Integer nres, Integer ngq, Integer *nz, Integer *nrz,
                     Integer tda, Integer tdzy, Integer tdr, Integer tdt,
                     Integer nrank, Integer *jdel, Integer *kdel, Integer kactiv[],
                     Integer kx[],  double a[], double res[], double r[],
                     double t[], double gq[], double zy[], double c[],
                     double s[], Nag_ce04nc *ce04nc, Nag_de04nb *de04nb);
  extern void e04ncu(Boolean cold, Boolean vertex,  Integer nclin, Integer nctotl,
                     Integer *nactiv, Integer *nartif, Integer *nfree, Integer n,
                     Integer lda, Integer istate[], Integer kactiv[],
                     double bigbnd, double tolact, double a[],
                     double ax[], double bl[], double bu[], double x[],
                     double wx[], double work[], Nag_ce04nc *ce04nc);
  extern void e04ncv(Boolean *unitq,  Integer *inform, Integer ifix, Integer iadd,
                     Integer jadd, Integer nactiv, Integer nz, Integer nfree,
                     Integer nrank, Integer nres, Integer ngq, Integer n,
                     Integer tda, Integer tdzy, Integer tdr, Integer tdt,
                     Integer kx[],  double condmx, double a[], double r[],
                     double t[], double res[], double gq[], double zy[],
                     double w[], double c[], double s[], 
                     NagError *ovflow, Nag_ce04nc *ce04nc, Nag_de04nb *de04nb);
  void e04ncw(const char *prbtyp, Integer tdh, Integer n, Integer *nrank,  double tolrnk,
              Integer kx[],  double h[],  Nag_PrintType print_level,
              Nag_FileSt *stream, Integer *inform);
  extern void e04ncx(Boolean *unitq, Integer *inform, Integer *nz, Integer *nfree,
                     Integer nrank, Integer nres, Integer ngq, Integer n,
                     Integer tdzy, Integer tda, Integer tdr, Integer tdt,
                     Integer istate[], Integer kx[], double condmx,
                     double a[], double r[], double t[], double res[],
                     double gq[], double zy[], double w[], double c[],
                     double s[], NagError *ovflow,
                     Nag_ce04nc *ce04nc, Nag_de04nb *de04nb);
  extern void e04ncy(Boolean *unitq, Boolean vertex, Integer *inform, Integer k1,
                     Integer k2, Integer *nactiv, Integer *nartif, Integer *nz,
                     Integer *nfree, Integer nrank, Integer *nrejtd, Integer nres,
                     Integer ngq, Integer n, Integer tdzy, Integer tda,
                     Integer tdr, Integer tdt, Integer istate[], Integer kactiv[],
                     Integer kx[],  double condmx, double a[], double r[],
                     double t[], double res[], double gq[], double zy[],
                     double w[], double c[], double s[], NagError *ovflow,
                     Nag_ce04nc *ce04nc, Nag_de04nb *de04nb);
  extern void e04ncz(const char *prbtyp, Boolean linobj,
                     Boolean *unitq,  Integer *inform, Integer *iter, Integer jinf,
                     Integer nclin, Integer nctotl, Integer *nactiv, Integer *nfree,
                     Integer nrank, Integer *nz, Integer *nrz, Integer n,
                     Integer tda, Integer tdr, Integer istate[], Integer kactiv[],
                     Integer kx[],  double *ctx, double *ssq, double ssq1,
                     double *suminf,  Integer *numinf,  double *xnorm,
                     double bl[], double bu[], double a[],
                     double clamda[], double ax[], double featol[],
                     double r[], double x[], double w[], Nag_E04_Opt *opt,
                     Nag_Comm *comm,  Nag_FileSt *stream, Nag_Search_State *st,
                     NagError *ovflow, Nag_ae04nc *ae04nc,
                     Nag_be04nb *be04nb, Nag_ce04nc *ce04nc,
                     Nag_de04nb *de04nb, Nag_fe04nb *fe04nb, Integer *local_error);
  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04nfc(Integer n, Integer nclin, double a[], 
                       Integer tda, double bl[], double bu[],
                       double cvec[], double h[], 
                       Integer tdh, NAG_E04NFC_FUN qphess_user,
                       double x[], double *obj, 
                       Nag_E04_Opt *options, Nag_Comm *comm,
                       NagError *fail);
  extern void e04nfg(const char *prbtyp, Integer n, Integer nclin, double a[], Integer tda,
                     double bl[], double bu[], double cvec[], double ax[], double h[], Integer tdh,
                     NAG_E04NFC_FUN qphess,
                     double x[], double *obj, double lambda[], Integer istate[],
                     Boolean vertex, Boolean cset, Nag_ae04mf *ae04mf, double w[],
                     Integer iw[], Nag_ee04mf *ee04mf, Nag_E04_Opt *opt, Nag_Comm *comm,
                     Nag_FileSt *stream, NagError *ovflow, Nag_EndState *endstate);
  extern void e04nfp(Boolean unitq, Integer it, Integer n, Integer *nactiv,
                     Integer *nfree, Integer ngq, Integer *nz, Integer *nrz,
                     Integer tda, Integer tdq, Integer tdt, Integer jdel,
                     Integer kdel, Integer kactiv[], Integer kx[], double a[],
                     double t[], double gqm[], double tgqm[], double q[],
                     double c[], double s[], Nag_de04nb *de04nb);
  extern void e04nfq(Boolean *unitq, Boolean vertex, Integer k1, Integer k2,
                     Integer *it, Integer *nactiv, Integer *nartif, Integer *nz,
                     Integer *nfree, Integer *nrejtd, Integer ngq, Integer n,
                     Integer tdq, Integer tda, Integer tdt, Integer istate[],
                     Integer kactiv[], Integer kx[],
                     double a[], double t[], double gqm[], double tgqm[], double q[],
                     double w[], double c[], double s[],
                     Nag_de04nb *de04nb, Nag_ee04mf *ee04mf, NagError *ovflow);
  extern void e04nfr(Boolean *unitq, Boolean rset, Integer *inform, Integer ifix,
                     Integer iadd, Integer jadd, Integer *it, Integer nactiv,
                     Integer nz, Integer nfree, Integer nrz, Integer ngq,
                     Integer n, Integer tda, Integer tdq, Integer tdr,
                     Integer tdt, Integer kx[], double condmx, double *drzz,
                     double a[], double r[], double t[], double gqm[], double tgqm[],
                     double q[], double w[], double c[], double s[],
                     Nag_de04nb *de04nb, Nag_ee04mf *ee04mf, NagError *ovflow);
  extern void e04nfs(const char *prbtyp, Boolean *header, Boolean rset,
                     Nag_PrintType print_level, Integer isdel,
                     Integer *jdel, Integer jadd, Integer n, Integer nclin,
                     Integer nactiv, Integer nfree, Integer nz, Integer nrz,
                     Integer tdr, Integer tdt, Integer istate[], double alfa,
                     double condrz, double condt, double drzz,
                     double grznrm, Integer numinf,
                     double suminf, Integer notopt, double objp,
                     double trusml, double ax[], double r[], double t[],
                     double x[], Integer kx[], Integer kactive[], double rlambda[],
                     double gq[], double work[], Nag_QP_Print *print_inf,
                     Nag_E04_Opt *opt, Nag_FileSt *stream, Nag_Comm *comm);
  extern void e04nft(Boolean cset, Integer n, Integer nclin, Nag_ae04mf *ae04mf);
  extern void e04nfu(Integer n, Integer jthcol, double h[], Integer tdh,
                     double x[], double hx[], Nag_Comm *comm);
  extern void e04nfv(Boolean delreg, Boolean posdef, Boolean statpt,
                     Boolean unitgz, Boolean unitq, Integer n, Integer nclin,
                     Integer nfree, Integer tda, Integer tdq, Integer tdr,
                     Integer nrz, Integer issave, Integer jdsave,
                     Integer kx[], double *dnorm, double *gzdz,
                     double a[], double ad[], double d[], double gq[],
                     double r[], double q[], double v[], Nag_ee04mf *ee04mf);
  extern void e04nfx(Boolean unitq, NAG_E04NFC_FUN qphess,
                     Integer maxnz, Integer n, Integer ngq, Integer *nrz,
                     Integer nz, Integer nfree, Integer tdq, Integer tdh,
                     Integer tdr, Integer kx[], double *hsize, double tolrnk,
                     double gq[], double h[], double r[], double q[],
                     double nag_hz[], double wrk[], Nag_Comm *comm, Nag_ee04mf *ee04mf);
  extern void e04nfy(Boolean *singlr, Boolean *posdef, Boolean *renewr,
                     Boolean unitq, Integer n, Integer nrz, Integer nfree,
                     Integer tdq, Integer tdh, Integer tdr, Integer kx[],
                     double *hsize, double *drzz, double tolrnk,
                     NAG_E04NFC_FUN qphess,
                     double h[], double r[], double q[],
                     double nag_hz[], double wrk[], Nag_Comm *comm, Nag_ee04mf *ee04mf);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04nfz(const char *prbtyp, char *msg, Boolean cset,
                     Boolean *unitq, Integer itmax,
                     Integer *nviol, Integer n, Integer nclin, Integer lda,
                     Integer ldh, Integer *nactiv, Integer *nfree, Integer *nrz,
                     Integer *nz, Integer istate[], Integer kactiv[], Integer kx[],
                     NAG_E04NFC_FUN qphess,
                     void (*print_iter)(const char *prbtyp, Boolean *header, Boolean rset,
                                        Nag_PrintType print_level, Integer isdel, Integer *jdel,
                                        Integer jadd, Integer n, Integer nclin, Integer nactiv,
                                        Integer nfree, Integer nz, Integer nrz, Integer tdr,
                                        Integer tdt, Integer istate[], double alfa, double condrz,
                                        double condt, double drzz, double grznrm,
                                        Integer numinf, double suminf, Integer notopt,
                                        double objqp, double trusml, double ax[], double r[],
                                        double t[], double x[], Integer kx[], Integer kactive[],
                                        double rlambda[], double gq[], double work[],
                                        Nag_QP_Print *print_inf, Nag_E04_Opt *opt,
                                        Nag_FileSt *stream, Nag_Comm *comm),
                     double *objqp, double *xnorm, double *hsize, double a[],
                     double ax[], double bl[], double bu[], double cvec[],
                     double featol[], double featlu[], double h[],
                     double x[], Nag_E04_Opt *opt, double w[],
                     Nag_de04nb *de04nb, Nag_ae04mf *ae04mf, Nag_ce04mf *ce04mf,
                     Nag_de04mf *de04mf, Nag_QP_Print *print_inf, Nag_FileSt *stream,
                     Nag_Comm *comm, Nag_ee04mf *ee04mf, NagError *ovflow);*/
  extern void e04nfz(const char *prbtyp, char *msg, Boolean cset,
                     Boolean *unitq, Integer itmax,
                     Integer *nviol, Integer n, Integer nclin, Integer lda,
                     Integer ldh, Integer *nactiv, Integer *nfree, Integer *nrz,
                     Integer *nz, Integer istate[], Integer kactiv[], Integer kx[],
                     NAG_E04NFC_FUN qphess,
                     NAG_E04NFZ_FUN print_iter,
                     double *objqp, double *xnorm, double *hsize, double a[],
                     double ax[], double bl[], double bu[], double cvec[],
                     double featol[], double featlu[], double h[],
                     double x[], Nag_E04_Opt *opt, double w[],
                     Nag_de04nb *de04nb, Nag_ae04mf *ae04mf, Nag_ce04mf *ce04mf,
                     Nag_de04mf *de04mf, Nag_QP_Print *print_inf, Nag_FileSt *stream,
                     Nag_Comm *comm, Nag_ee04mf *ee04mf, NagError *ovflow);
  extern NAG_DLL_EXPIMP void NAG_CALL 
  e04nkc(Integer n, Integer m, Integer nnz, Integer iobj, Integer ncolh, 
         NAG_E04NKC_HESSFUN qphx, double a[], Integer ha[], Integer ka[], 
         double bl[], double bu[], double xs[], 
         Integer *ninf, double *suminf, double *obj, 
         Nag_E04_Opt *options, Nag_Comm *user_comm, NagError *fail);
  extern void e04nkg(Integer nbs, Integer ngobj, Integer ngobj0, Integer kbs[],
                     double gobj[], double gbs[], Integer iparm[], double rparm[]);
  extern void e04nkh(Integer nr, Integer lenr,  double r[], double v[],
                     double w[],  Integer lastv);
  extern void e04nkj(Integer m, Integer maxs, Integer mbs, Integer n, Integer nb,
                     Integer *ns, Integer *nssave, Integer hs[], Integer kbs[],
                     double bl[], double bu[], double xs[],
                     Integer iparm[], double rparm[],
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  extern void e04nkk(Integer j, Integer iobj, Integer n, char **names, char *name);
  //Cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04nkl(Boolean ondisk, Integer m, Integer n, Integer nb,
                     Integer nnobj, Integer ne, Integer nka,
                     double a[], Integer ha[], Integer ka[], Integer hs[],
                     double ascale[], double bl[], double bu[], double gobj[], 
                     double pi[], double rc[], double xs[], double y[], 
                     char **names, const char *istate, Integer iz[], Integer leniz,
                     double z[], Integer lenz, Integer iparm[], double rparm[],
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);*/
  extern void e04nkl(Boolean ondisk, Integer m, Integer n, Integer nb,
                     Integer nnobj, Integer ne, Integer nka,
                     double a[], Integer ha[], Integer ka[], Integer hs[],
                     double ascale[], double bl[], double bu[], double gobj[], 
                     double dpi[], double rc[], double xs[], double y[], 
                     char **names, const char *istate, Integer iz[], Integer leniz,
                     double z[], Integer lenz, Integer iparm[], double rparm[],
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  extern void e04nkm(/* Boolean ondisk, */double bplus, double tolfea,
                     double tolopt,  Integer *js,  double d1, double d2,
                     double *djtest,  Integer j, const char *name,
                     double xj, double cj, double b1, double b2,
                     double dj,  Integer k, Integer number,  double clamda,
                     Integer n, Integer m, Integer iparm[],  double rparm[],
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  extern void e04nkn(Nag_ProblemType type, Integer k, char *istate);
  extern void e04nkr(Boolean initialize, Integer iparm[], double rparm[], 
                     Nag_E04_Opt *opt);
  //Cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04nks(NAG_E04NKC_HESSFUN_WRAP hx, NAG_E04NKC_HESSFUN hx1, 
                     Integer snmodx, Nag_Start start, Integer lenb, 
                     Integer mxx, Integer nxx, Integer nbxx, Integer nexx, 
                     Integer nkax, Integer iobjxx, double objadd, double *obj, 
                     double a[], Integer ha[], Integer ka[], double b[], double bl[],
                     double bu[], double gobj[], char **names, Integer hs[],  
                     double x0[], double xs[], double pi[], double rc[],
                     Integer *inform, Integer *ns, Integer iz[], Integer leniz,
                     double z[], Integer lenz, Nag_ProblemType *type, Integer *itqp, 
                     Integer *mxitqp, Integer iparm[], double rparm[],
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);*/
  extern void e04nks(NAG_E04NKC_HESSFUN_WRAP hx, NAG_E04NKC_HESSFUN hx1, 
                     Integer snmodx, Nag_Start start, Integer lenb, 
                     Integer mxx, Integer nxx, Integer nbxx, Integer nexx, 
                     Integer nkax, Integer iobjxx, double objadd, double *obj, 
                     double a[], Integer ha[], Integer ka[], double b[], double bl[],
                     double bu[], double gobj[], char **names, Integer hs[],  
                     double x0[], double xs[], double dpi[], double rc[],
                     Integer *inform, Integer *ns, Integer iz[], Integer leniz,
                     double z[], Integer lenz, Nag_ProblemType *type, Integer *itqp, 
                     Integer *mxitqp, Integer iparm[], double rparm[],
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  //Cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04nkt(Boolean print,  Integer m, Integer n, Integer nb, Integer ngobj,
                     Integer nscl, Integer ne, Integer nka, double a[],  
                     Integer ha[], Integer ka[], Integer hs[], double ascale[], 
                     double bl[], double bu[], double gobj[], char **names,
                     double pi[], double rc[], double xs[], double y[],  Integer iz[], 
                     Integer leniz,  double z[], Integer lenz,  Nag_ProblemType type,  
                     double *pnorm1, double *pnorm2,
                     Integer iparm[], double rparm[],
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);*/
  extern void e04nkt(Boolean print,  Integer m, Integer n, Integer nb, Integer ngobj,
                     Integer nscl, Integer ne, Integer nka, double a[],  
                     Integer ha[], Integer ka[], Integer hs[], double ascale[], 
                     double bl[], double bu[], double gobj[], char **names,
                     double dpi[], double rc[], double xs[], double y[],  Integer iz[], 
                     Integer leniz,  double z[], Integer lenz,  Nag_ProblemType type,  
                     double *pnorm1, double *pnorm2,
                     Integer iparm[], double rparm[],
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  //Cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04nkv(NAG_E04NKC_HESSFUN_WRAP sqhx, NAG_E04NKC_HESSFUN qphx, 
                     Nag_ProblemType type, Boolean needb, Integer lenb, Integer lenb0, 
                     Integer lenr, Integer m, Integer maxs, Integer mbs, Integer n, 
                     Integer nb, Integer ngqp0, Integer ngobj0, Integer ngobj, 
                     Integer nnh, Integer *ns, Integer nscl, Integer numleq, 
                     Integer itmax, Integer *itqp, double objadd, double *obj,
                     Integer iobj, double tolfp, double tolqp, double tolx, Integer ne,
                     Integer nka, double a[], Integer ha[], Integer ka[], Integer hfeas[], 
                     Integer hs[], Integer kbs[], double ascale[], double b[], 
                     double bl[], double bu[], double blbs[], double bubs[], 
                     double blslk[], double buslk[], double gobj[], double gobjqp[], 
                     double gbs[], double pi[], double r[], double rc[], double rg[], 
                     double rhs[], double xbs[], double x0[], double xs[], double xdif[],
                     Integer iy[], Integer iy2[], double y[], double y2[], double yq[], 
                     double t[], Integer iz[], Integer leniz, double z[], Integer lenz, 
                     Integer iparm[], double rparm[],
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);*/
  extern void e04nkv(NAG_E04NKC_HESSFUN_WRAP sqhx, NAG_E04NKC_HESSFUN qphx, 
                     Nag_ProblemType type, Boolean needb, Integer lenb, Integer lenb0, 
                     Integer lenr, Integer m, Integer maxs, Integer mbs, Integer n, 
                     Integer nb, Integer ngqp0, Integer ngobj0, Integer ngobj, 
                     Integer nnh, Integer *ns, Integer nscl, Integer numleq, 
                     Integer itmax, Integer *itqp, double objadd, double *obj,
                     Integer iobj, double tolfp, double tolqp, double tolx, Integer ne,
                     Integer nka, double a[], Integer ha[], Integer ka[], Integer hfeas[], 
                     Integer hs[], Integer kbs[], double ascale[], double b[], 
                     double bl[], double bu[], double blbs[], double bubs[], 
                     double blslk[], double buslk[], double gobj[], double gobjqp[], 
                     double gbs[], double dpi[], double r[], double rc[], double rg[], 
                     double rhs[], double xbs[], double x0[], double xs[], double xdif[],
                     Integer iy[], Integer iy2[], double y[], double y2[], double yq[], 
                     double t[], Integer iz[], Integer leniz, double z[], Integer lenz, 
                     Integer iparm[], double rparm[],
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  extern void e04nkw(NAG_E04NKC_HESSFUN qphx,  Integer nnh, Integer ne, Integer nka,
                     double a[],  Integer ha[], Integer ka[],  double x[],
                     double hx[],  Integer nstate, Integer iz[], Integer leniz,
                     double z[],  Integer lenz, Integer iparm[],
                     double rparm[], Nag_Comm *comm);
  extern void e04nkx(Integer nrealloc, Integer minfac, Integer *miniz, Integer *minz, 
                     Integer iparm[], double rparm[]);
  extern void e04nlg(Boolean pivot,  Integer *inform, Integer n,  double hdmin,
                     double *d_max,  Integer *irank, Integer perm[], Integer lenh,
                     double h[]);
  extern void e04nlh(Integer nr, Integer lenr,  double r[], double *drmin,
                     double *rmax,  Integer iparm[],  double rparm[]);
  extern void e04nlj(Integer jq, Integer jr, Integer lenr, Integer nr,
                     double r[], double w[]);
  extern void e04nlk(Integer n, Integer lenr,  double r[], double v[],
                     double w[],  Integer lastv,  double vnorm,
                     double tolz);
  extern void e04nll(MatrixTranspose transpose,  Integer lenr, Integer nr,  double r[],
                     double y[]);
  extern void e04nlm(Integer *inform, Integer nbs, Integer jqsave, Integer kbs[],
                     double *gtd, double d[],  Integer iparm[], double rparm[], 
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  extern void e04nln(Integer m, Integer mbs, Integer n, Integer nb, Integer ns,
                     Integer *kbsq,  double *pivot,  Integer ne, Integer nka,
                     double a[],  Integer ha[], Integer ka[], Integer kbs[],
                     double bl[], double bu[], double xbs[],
                     double y[],  Integer iparm[],  double rparm[],
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  extern void e04nlp(Integer nbs,  double featol, double stepmx,
                     Integer hfeas[],  double blbs[], double bubs[],
                     double xbs[], double y[],  Boolean *hitlow, Boolean *move,
                     Boolean *onbnd, Boolean *unbndd,  double *bound,
                     double *exact, double *alpha, double *alphap,
                     Integer iparm[],  double rparm[]);
  extern void e04nlq(Nag_DegenJob job, Integer *inform, Integer nb, double *featol,
                     double tolx, Integer hs[], double bl[], double bu[], double xs[],
                     Integer iparm[], double rparm[], Nag_SparseQP_Save_Vars *vsave,
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  extern void e04nlr(Boolean fix_sbasics,  Integer m, Integer maxs, Integer mbs, Integer n,
                     Integer nb, Integer *ns, Integer hs[], Integer kbs[],
                     double bl[], double bu[], double blbs[],
                     double bubs[], double xs[], double xbs[],
                     Integer iparm[],  double rparm[]);
  extern void e04nls(Boolean qpstep, Boolean posdef,  Integer lenr, Integer n,
                     double r[], double g[], double d[], double *gd,
                     double *dhd);
  extern void e04nlt(Boolean pivot,  Integer lenr, Integer m, Integer maxr,
                     Integer mbs, Integer nb, Integer *ns,  double hdmax,
                     Integer hs[], Integer kbs[], Integer perm[],  double bl[],
                     double bu[], double blbs[], double bubs[],
                     double xs[], double xbs[], double r[],
                     Integer iparm[],  double rparm[],
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  extern void e04nlu(Nag_SetStateMode state_mode,  Integer nb,  const double bl[], const double bu[],
                     Integer hs[],  double xs[]);
  extern void e04nlv(NAG_E04NKC_HESSFUN_WRAP hx, NAG_E04NKC_HESSFUN hx1, Integer lenr, Integer m,
                     Integer mbs, Integer n, Integer nb, Integer nnh, Integer ns,
                     Integer ne, Integer nka,  double a[],  Integer ha[],
                     Integer ka[],  double *hdmax,  Integer kbs[],
                     double r[], double v[], double w[], double y[],
                     Integer iz[], Integer leniz,  double z[],  Integer lenz,
                     Integer iparm[],  double rparm[], Nag_Comm *comm);
  extern void e04nlw(Nag_ProblemType type, Boolean prtfes, Boolean jstfes, Integer mbs,
                     Integer ns, Integer itn, double step, Integer ninf, 
                     double suminf, double obj, Integer kbs[], double xbs[], 
                     Integer iparm[], double rparm[],
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  extern void e04nlx(Boolean incres, Boolean *needpi,  Integer m1, Integer m,
                     Integer nb,  double featol, double *step,
                     Integer hfeas[], Integer hs[], Integer kbs[],  double bl[],
                     double bu[], double blbs[], double bubs[],
                     double xbs[], double xs[], double y[],
                     double yq[],  Integer iz[], Integer leniz,  double z[],
                     Integer lenz, Integer iparm[],  double rparm[],
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  //Cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04nly(Nag_ProblemType type,  Boolean *needlu,  Integer m, Integer n,
                     Integer nb, Integer itmax, Integer *itlp,  double objadd,
                     Integer iobj,  double tolfp, double tollp,
                     double tolx,  Integer ne, Integer nka,  double a[],
                     Integer ha[], Integer ka[], Integer hfeas[], Integer hs[],
                     Integer kbs[],  double ascale[], double b[],
                     Integer lenb,  double bl[], double bu[],
                     double blbs[], double bubs[], double gbs[],
                     double pi[], double rc[], double xbs[],
                     double xs[],  Integer iy[], Integer iy2[],  double y[],
                     double y2[], double yq[],  Integer iz[], Integer leniz,
                     double z[],  Integer lenz, Integer iparm[], double rparm[],
                     Nag_SparseQP_Save_Vars *vsave,
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);*/
  extern void e04nly(Nag_ProblemType type,  Boolean *needlu,  Integer m, Integer n,
                     Integer nb, Integer itmax, Integer *itlp,  double objadd,
                     Integer iobj,  double tolfp, double tollp,
                     double tolx,  Integer ne, Integer nka,  double a[],
                     Integer ha[], Integer ka[], Integer hfeas[], Integer hs[],
                     Integer kbs[],  double ascale[], double b[],
                     Integer lenb,  double bl[], double bu[],
                     double blbs[], double bubs[], double gbs[],
                     double dpi[], double rc[], double xbs[],
                     double xs[],  Integer iy[], Integer iy2[],  double y[],
                     double y2[], double yq[],  Integer iz[], Integer leniz,
                     double z[],  Integer lenz, Integer iparm[], double rparm[],
                     Nag_SparseQP_Save_Vars *vsave,
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  //Cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04nlz(Integer m, Integer n, Integer nb, Integer nng, Integer nng0,
                     Integer nnh, Integer ns,  Boolean *incres,  Integer ne,
                     Integer nka,  double a[],  Integer ha[], Integer ka[],
                     Integer *newsb, Integer *nonopt, Integer hs[],  double bl[],
                     double bu[], double g[], double pi[], double rc[],
                     Integer iparm[],  double rparm[]);*/
  extern void e04nlz(Integer m, Integer n, Integer nb, Integer nng, Integer nng0,
                     Integer nnh, Integer ns,  Boolean *incres,  Integer ne,
                     Integer nka,  double a[],  Integer ha[], Integer ka[],
                     Integer *newsb, Integer *nonopt, Integer hs[],  double bl[],
                     double bu[], double g[], double dpi[], double rc[],
                     Integer iparm[],  double rparm[]);
  extern void e04nmg(Boolean stats_requd,  Integer m, Integer n, Integer nb, Integer ne,
                     Integer nka,  double a[],  Integer ha[], Integer ka[],
                     double bl[], double bu[],  Integer hrtype[],
                     Integer iparm[],  double rparm[],
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  extern NAG_DLL_EXPIMP void NAG_CALL e04nmh(MatrixTranspose transpose,  Integer ne, Integer lenka,  double a[],
                     Integer ha[], Integer ka[],  double alpha, double x[],
                     Integer lenx,  double beta, double y[],  Integer leny,
                     Integer iparm[],  double rparm[]);
  extern void e04nmj(Boolean *needlu,  Nag_SparseQP_LU_Type typelu,  Integer m, Integer mbs,
                     Integer n, Integer nb, Integer nnl, Integer ns, Integer *nswap,
                     Integer ne, Integer nka,  double a[],  Integer ha[],
                     Integer ka[], Integer kbs[], Integer hs[],  double b[],
                     Integer lenb,  double bl[], double bu[],
                     double blbs[], double bubs[], double xbs[],
                     double xs[],  Integer iy[], Integer iy2[],  double y[],
                     double y2[],  Integer iz[], Integer leniz,  double z[],
                     Integer lenz, Integer iparm[],  double rparm[],
                     Nag_SparseQP_Save_Vars *vsave,
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  extern void e04nmk(Integer nb,  double bl[], double bu[], double xs[],
                     double *binf,  Integer *jbinf);
  extern void e04nml(Nag_SparseQP_BasisFactType basis_fact,  Integer *inform, 
                     Integer m, Integer n, Integer nbs,
                     Integer ne, Integer nka,  double a[],  Integer ha[],
                     Integer ka[], Integer kbs[], Integer ip[],  double alu[],
                     Integer indc[], Integer indr[], Integer lena, Integer iy[],
                     Integer iy2[],  double y[],  Integer iz[], Integer leniz,
                     Integer iparm[], double rparm[], 
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  extern void e04nmm(Integer mode, Integer nrealloc, Integer minfac, Integer m, 
                     Integer n, Integer ne, Integer miniz, Integer minz, 
                     Integer *nizmin, Integer *nzmin, Integer iparm[],  double rparm[]);
  extern void e04nmn(Integer *inform, Integer jrep, Integer m,  double w[],
                     Integer iz[], Integer leniz,  double z[],  Integer lenz,
                     Integer iparm[],  double rparm[]);
  extern void e04nmp(MatrixTranspose transpose, Integer m, Integer n, Integer lenkbs, 
                     Integer kbs[], Integer ne, Integer nka, double a[], Integer ha[],
                     Integer ka[], double alpha, double x[], Integer lenx, double beta, 
                     double y[], Integer leny, Integer iparm[], double rparm[]);
  extern void e04nmq(Nag_SparseQP_LU_SolveType solve_type,  Integer *inform, Integer m,  double w[],
                     double y[],  Integer iz[], Integer leniz,  double z[],
                     Integer lenz, Integer iparm[],  double rparm[]);
  extern void e04nmr(Integer lcrash, Integer m, Integer n, Integer nb, Integer ne,
                     Integer nka,  double a[],  Integer ha[], Integer ka[],
                     Integer hpiv[], Integer hs[], Integer hrtype[],  double bl[],
                     double bu[], double xs[], Integer iparm[], double rparm[],
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
  extern void e04nms(Integer nb, Integer jobj,  double bl[], double bu[],
                     double rc[], double xs[], double *dinf,
                     Integer *jdinf);
  extern void e04nmt(Integer nbs, Integer m, Integer nb, Integer hs[], Integer ip[],
                     Integer kbs[], Integer kbsold[], Integer locr[], Integer *nswap);
  //Cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04nmu(Boolean feasbl,  double featol,  Integer minimz, Integer m,
                     Integer n, Integer nb, Integer nnobj, Integer ne, Integer nka,
                     double a[],  Integer ha[], Integer ka[], Integer hs[],
                     double bl[], double bu[], double gobj[],
                     double pi[], double rc[], double xs[],
                     Integer iparm[],  double rparm[]);*/
  extern void e04nmu(Boolean feasbl,  double featol,  Integer minimz, Integer m,
                     Integer n, Integer nb, Integer nnobj, Integer ne, Integer nka,
                     double a[],  Integer ha[], Integer ka[], Integer hs[],
                     double bl[], double bu[], double gobj[],
                     double dpi[], double rc[], double xs[],
                     Integer iparm[],  double rparm[]);
  extern void e04nmv(Integer m, Integer n, Integer nb, Integer nnl, Integer nncon,
                     Integer nnjac, Integer hrtype[], Integer ne, Integer nka,
                     double a[],  Integer ha[], Integer ka[], double ascale[], 
                     double bl[], double bu[], double rmin[], double rmax[],  
                     Integer iparm[], double rparm[], 
                     Nag_E04_Opt *opt, Nag_Comm *comm, Nag_FileSt *stream);
 //Cheney change pi[] to dpi[] 2006-6-5
 /*extern void e04nmw(Boolean scale,  Integer m, Integer n, Integer nb, Integer ne,
                     Integer nka,  double a[],  Integer ha[], Integer ka[],
                     double ascale[], double bl[], double bu[],
                     double pi[], double xs[],  Integer iparm[],
                     double rparm[]);*/
  extern void e04nmw(Boolean scale,  Integer m, Integer n, Integer nb, Integer ne,
                     Integer nka,  double a[],  Integer ha[], Integer ka[],
                     double ascale[], double bl[], double bu[],
                     double dpi[], double xs[],  Integer iparm[],
                     double rparm[]);
  extern void e04nmx(Integer mbs, Integer m, Integer n, Integer nb, double w[],
                     Integer ip[], Integer iq[], double bl[], double bu[],
                     Integer hs[], Integer kbs[], double xs[], Integer iparm[], 
                     double rparm[], Nag_E04_Opt *opt, Nag_Comm *comm,
                     Nag_FileSt *stream);
  extern void e04nmy(Integer jq, Integer m, Integer n, Integer ne, Integer nka,
                     const double a[],  const Integer ha[], const Integer ka[],  double y[]);
  extern void e04nmz(Boolean xbs_to_xs,  Integer ms, Integer nb, const Integer kbs[],
                     double xbs[], double xs[]);
  extern void e04paz(Nag_Search_State *st);
  extern void e04uc0(Boolean debug, Boolean *done, Boolean *first, Boolean *imprvd,
                     Integer *inform, double alfmax, double alfsml, double epsaf,
                     double eta, double *xtry, double ftry, double oldf, double oldg,
                     double *tolabs, double tolrel, double toltny,
                     double *alfa, double *alfbst, double *fbest, Nag_Uc01St *st);
  extern void e04uc1(Boolean debug, Boolean *done, Boolean *first, Boolean *imprvd,
                     Integer *inform, double alfmax, double epsaf, double eta,
                     double *xtry, double ftry, double gtry, double oldf,
                     double oldg, double *tolabs, double tolrel, double toltny,
                     double *alfa, double *alfbst, double *fbest, double *gbest,
                     Nag_Uc01St *st);
  extern NAG_DLL_EXPIMP void NAG_CALL 
  e04ucc(Integer n, Integer nclin, Integer ncnlin, double a[], 
         Integer tda, double bl[], double bu[],
         NAG_E04UCC_FUN objfun, NAG_E04UCC_CONFUN confun,
         double x[], double *objf, double objgrad[],
         Nag_E04_Opt *options, Nag_Comm *user_comm, 
         NagError *fail);
  extern void e04ucg(Boolean firstv, Boolean *hitlow,  Integer istate[],
                     Integer *inform, Integer *jadd, Integer n, Integer nctotl,
                     Integer numinf,  double *alfa, double *palfa,
                     double *atphit, double bigalf, double bigbnd,
                     double pnorm, double anorm[], double ap[],
                     double ax[], double bl[], double bu[],
                     double featol[], double p[], double x[], Nag_fe04nb *fe04nb);
  extern void e04uch(Boolean firstv, Boolean negstp,  double bigalf,
                     double bigbnd, double pnorm,  Integer *jadd1,
                     Integer *jadd2,  double *palfa1, double *palfa2,
                     Integer istate[], Integer n, Integer nctotl,
                     double anorm[], double ap[], double ax[],
                     double bl[], double bu[], double featol[],
                     double p[], double x[], Nag_fe04nb *fe04nb);
  extern void e04ucj(Boolean *first, Boolean debug, Boolean *done, Boolean *imprvd,
                     Integer *inform, Integer maxf, Integer *numf,
                     double alfmax, double alfsml, double epsaf,
                     double g0, double targtg, double ftry,
                     double *tolabs, double tolrel, double toltny,
                     double *alfa, double *alfbst, double *fbest, Nag_UcjkSt *st);
  extern void e04uck(Boolean *first, Boolean debug, Boolean *done, Boolean *imprvd,
                     Integer *inform, Integer maxf, Integer *numf,
                     double alfmax, double epsaf, double g0,
                     double targtg, double ftry, double gtry,
                     double *tolabs, double tolrel, double toltny,
                     double *alfa, double *alfbst, double *fbest,
                     double *gbest, Nag_UcjkSt *st);
  extern void e04ucl(char *lsumry, Boolean unitq, Integer n, Integer ncnln,
                     Integer nfree, Integer nz, Integer tdcj1, Integer tdcj2,
                     Integer tdzy, Integer tdr, Integer kx[], double alfa,
                     double glf1, double glf2, double qpcurv,
                     double cjac1[], double cjac2[], double cjdx1[],
                     double cjdx2[], double cs1[], double cs2[],
                     double gq1[], double gq2[], double hpq[],
                     double rpq[], double qpmul[], double r[],
                     double omega[], double zy[], double wrk1[],
                     double wrk2[], Nag_de04uc *de04uc, Nag_ee04nb *ee04nb,
                     Nag_fe04uc *fe04uc);
  extern void e04ucm(Boolean unitq, Integer ncqp, Integer nactiv, Integer nfree,
                     Integer nz, Integer n, Integer nlnx, Integer nctotl,
                     Integer tdzy, Integer tdaqp, Integer tdr, Integer tdt,
                     Integer istate[], Integer kactiv[], Integer kx[],
                     double *dxnorm, double *gdx, double aqp[],
                     double adx[], double bl[], double bu[],
                     double rpq[], double rpq0[], double dx[],
                     double gq[], double r[], double t[], double zy[],
                     double work[], Nag_fe04uc *fe04uc);
  extern void e04ucn(Boolean feasqp, Integer n, Integer nclin, Integer ncnln,
                     double *objalf, double *grdalf, double qpcurv,
                     Integer istate[],  double cjdx[], double cmul[],
                     double cs[], double dlam[], double rho[],
                     double violn[], double work1[], double work2[], 
                     Nag_de04uc *de04uc, Nag_fe04uc *fe04uc);
  extern void e04ucp(Integer n, Integer nclin, Integer ncnln, Integer nctotl,
                     Integer *litotl, Integer *lwtotl, Nag_ae04nc *ae04nc,
                     Nag_ae04uc *ae04uc, Nag_be04nb *be04nb);
  extern void e04ucr(Boolean needfd,  Integer *inform, Integer n, Integer ncnln,
                     Integer tdcj, Integer tdcju, Integer *nfun, Integer *ngrad,
                     Integer needc[],
                     NAG_E04UCC_CONFUN confun, NAG_E04UCC_FUN objfun,
                     double *alfa, double *alfbnd, double *alfmax,
                     double alfsml, double dxnorm, double epsrf,
                     double eta, double *gdx, double grdalf,
                     double glf1, double *glf, double *objf,
                     double *objalf, double qpcurv, double xnorm,
                     double c[], double c2[], double cjac[],
                     double cjacu[], double cjdx[], double cjdx2[],
                     double cmul1[], double cmul[], double cs1[],
                     double cs[], double dx[], double dlam[],
                     double dslk[], double grad[], double gradu[],
                     double qpmul[], double rho[], double slk1[],
                     double slk[], double x1[], double x[],
                     double work[], double w[],
                     Nag_de04uc *de04uc, Nag_fe04uc *fe04uc, Nag_Comm *comm);
  extern void e04ucs(Boolean cold,  Integer n, Integer nclin, Integer ncnln,
                     Integer nctotl, Integer *nactiv, Integer nfree, Integer *nz,
                     Integer istate[], Integer kactiv[], double bigbnd,
                     double tolact, double bl[], double bu[],
                     double c[], Nag_fe04uc *fe04uc);
  extern void e04uct(Boolean ktcond[], Boolean convrg, char *lsumry,
                     Integer tdr, Integer tdt,
                     Integer n, Integer nclin, Integer ncnln, Integer nctotl,
                     Integer nactiv, Integer linact, Integer nlnact, Integer nz,
                     Integer nfree, Integer majit0, Integer majits, Integer minits,
                     Integer istate[], double alfa, Integer nfun,
                     double condhz, double condh, double condt,
                     double objalf, double objf, double gfnorm,
                     double gznorm, double cvnorm, double ax[],
                     double c[], double r[], double t[], double violn[],
                     double x[], double work[], Nag_E04_Opt *opt, Nag_Comm *comm, 
                     Nag_Search_State *st, Nag_de04uc *de04uc,
                     Nag_FileSt *stream);
  extern void e04ucu(Boolean *feasqp, Boolean *unitq, Integer *nqperr,
                     Integer *majits, Integer *minits, Integer n, Integer nclin,
                     Integer ncnln, Integer tdcj, Integer tdaqp, Integer tdr,
                     Integer *linact, Integer *nlnact, Integer *nactiv, Integer *nfree,
                     Integer *nz, Integer *numinf, Integer istate[], Integer kactiv[],
                     Integer kx[], double *dxnorm, double *gdx,
                     double *qpcurv, double aqp[], double adx[],
                     double anorm[], double ax[], double bl[],
                     double bu[], double c[], double cjac[],
                     double clamda[], double cmul[], double cs[],
                     double dlam[], double dslk[], double dx[],
                     double qpbl[], double qpbu[], double qptol[],
                     double r[], double rho[], double slk[],
                     double violn[], double x[], double wtinf[],
                     double w[], Nag_E04_Opt *opt, Nag_Comm *comm, 
                     Nag_FileSt *stream, Nag_Search_State *st, NagError *ovflow,
                     Nag_ae04nc *ae04nc, Nag_be04nb *be04nb, Nag_ce04nc *ce04nc,
                     Nag_de04nb *de04nb, Nag_de04uc *de04uc, Nag_fe04nb *fe04nb,
                     Nag_fe04uc *fe04uc, Integer *local_error);
  extern void e04ucw(Integer n, Integer nclin, Integer ncnln, Integer istate[],
                     double bigbnd, double *cvnorm, double *errmax,
                     Integer *jmax, Integer *nviol,  double ax[], double bl[],
                     double bu[], double c[], double featol[],
                     double x[], double work[], Nag_fe04uc *fe04uc);
  extern void e04ucy(Nag_DerivSet *deriv_level,
                     Integer *nfun, Integer *ngrad, Integer tdcj, Integer tdcju,
                     Integer n, Integer ncnln,
                     NAG_E04UCC_CONFUN confun, NAG_E04UCC_FUN objfun,
                     Integer needc[], double bigbnd,
                     double epsrf, double cdint, double fdint,
                     double fdchk, double *fdnorm, double *objf,
                     double xnorm, double bl[], double bu[], double c[],
                     double c1[], double cjac[], double cjacu[], double cjdx[],
                     double dx[], double grad[], double gradu[], double hforwd[],
                     double hcntrl[], double x[], double wrk1[], double wrk2[],
                     Nag_Comm *comm, Nag_Deriv_Inf *diff,
                     const Nag_DebugSt *debug, Nag_Grad_Chk_St g_chk, int *error,
                     Nag_GPrintSt *gprint);
  extern void e04ucz(Boolean *unitq, Integer *inform, Integer *majits,
                     Integer n, Integer nclin, Integer ncnln,
                     Integer nctotl, Integer *nactiv, Integer *nfree,
                     Integer *nz, Integer tdcj, Integer tdcju, Integer tdaqp,
                     Integer tdr, Integer *nfun, Integer *ngrad, Integer istate[],
                     Integer kactiv[], Integer kx[], double *objf,
                     double *fdnorm, double *xnorm,
                     NAG_E04UCC_CONFUN confun, NAG_E04UCC_FUN objfun,
                     double aqp[], double ax[],
                     double bl[], double bu[], double c[],
                     double cjac[], double cjacu[], double clamda[],
                     double featol[], double grad[], double gradu[],
                     double r[], double x[],  Integer iw[], double w[],
                     Nag_Deriv_Inf *diff, Nag_E04_Opt *opt, Nag_Comm *comm,
                     Nag_FileSt *stream, Nag_Search_State *st, NagError *ovflow,
                     Nag_ae04nc *ae04nc, Nag_ae04uc *ae04uc,
                     Nag_be04nb *be04nb, Nag_ce04nc *ce04nc,
                     Nag_de04nb *de04nb, Nag_de04uc *de04uc,
                     Nag_ee04nb *ee04nb, Nag_fe04nb *fe04nb,
                     Nag_fe04uc *fe04uc, Integer *local_error);
  extern void e04udn_f(Integer no, char *char_, Integer char_len);
  extern void e04udr(Boolean unitq, Integer n, Integer nfree, Integer nz,
                     Integer nq, Integer nrowr, Integer iperm[], Integer kx[],
                     double gq[], double r[], double zy[],
                     double work[], double qrwork[], Nag_ee04nb *ee04nb);
  extern void e04uds(Boolean central, Integer ncolj,
                     Integer ncoluj, Integer n, Integer ncnln,
                     double bigbnd, double cdint, double fdint,
                     double *fdnorm, double objf,
                     NAG_E04UCC_CONFUN confun, NAG_E04UCC_FUN objfun,
                     Integer needc[],
                     double bl[], double bu[], double c[], double c1[],
                     double c2[], double cjac[], double ujac[], double grad[],
                     double ugrad[], double hforwd[], double hcntrl[], double x[],
                     Nag_Comm *comm, Nag_Deriv_Inf diff);
  extern void e04udt(Integer *inform, Integer n, Integer nclin, Integer ncnln,
                     double *alfa, double alfmin, double alfmax,
                     double bigbnd, double dxnorm, double anorm[],
                     double adx[], double ax[], double bl[],
                     double bu[], double dslk[], double dx[],
                     double slk[], double x[], Nag_fe04nb *fe04nb);
  extern NAG_DLL_EXPIMP void NAG_CALL
  e04ugc (NAG_E04UGC_CONFUN confun, NAG_E04UGC_OBJFUN objfun,
          Integer n, Integer m, Integer ncnln, Integer nonln,
          Integer njnln, Integer iobj, Integer nnz, double a[],
          const Integer ha[], const Integer ka[], double bl[], double bu[],
          double xs[],Integer *ninf, double *sinf, double *obj,
          Nag_Comm * user_comm, Nag_E04_Opt *options,
          NagError *fail);
  //Cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04ugg  (Boolean feasbl, double featol, Integer iobj, Integer minimz,
                       double wtinf, Integer m, Integer n, Integer nb,
                       Integer nnobj, Integer ne, Integer nka, const double a[],
                       const Integer ha[], const Integer ka[],
                       const Integer hestat[], const Integer hs[],
                       const double bl[], const double bu[], const double gobj[],
                       const double pi[], double rc[], const double xs[]);*/
  extern void e04ugg  (Boolean feasbl, double featol, Integer iobj, Integer minimz,
                       double wtinf, Integer m, Integer n, Integer nb,
                       Integer nnobj, Integer ne, Integer nka, const double a[],
                       const Integer ha[], const Integer ka[],
                       const Integer hestat[], const Integer hs[],
                       const double bl[], const double bu[], const double gobj[],
                       const double dpi[], double rc[], const double xs[]);
  extern void e04ugh  (Integer lcrash, Integer lprint, Integer m, Integer n,
                       Integer nb, Integer icrash, double tcrash, Integer ne,
                       Integer nka, const double a[], const Integer ha[], const Integer ka[],
                       Integer hpiv[], Integer hs[], const Integer hrtype[], const double bl[],
                       const double bu[], double xs[], const Integer iw[], Integer leniw,
                       const double rw[], Integer lenrw, Nag_FileSt *stream);
  extern void e04ugj  (const char *job, Integer m, Integer n, Integer nb,
                       Integer ne, Integer nka, const double a[], const Integer ha[],
                       const Integer ka[], const double bl[], const double bu[], Integer hrtype[],
                       const Integer iw[], Integer leniw, const double rw[], Integer lenrw, Nag_FileSt *stream);
  //cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04ugk  (const char *job, Integer m, Integer n, Integer nb,
                       Integer iobj, double plinfy, double *sclobj, Integer ne,
                       Integer nka, double a[], const Integer ha[], const Integer ka[],
                       const double ascale[], double bl[], double bu[], double pi[],
                       double xs[]);*/
  extern void e04ugk  (const char *job, Integer m, Integer n, Integer nb,
                       Integer iobj, double plinfy, double *sclobj, Integer ne,
                       Integer nka, double a[], const Integer ha[], const Integer ka[],
                       const double ascale[], double bl[], double bu[], double dpi[],
                       double xs[]);
  extern void e04ugl  (Integer n, Integer nb, Integer iobj, double bl[],
                       const double bu[], const double rc[], const double xs[], double *dinf,
                       Integer *jdinf);
  extern void e04ugm  (Boolean Initialize, Integer iparm[], double rparm[],
                       Nag_E04_Opt opt);
  extern void e04ugp  (const char *job, Integer *inform, Integer m, double z[],
                       double y[], Integer iw[], Integer leniw, double rw[],
                       Integer lenrw);
  extern void e04ugq  (const char *job, double tolz, Integer n, Integer lenkbs,
                       const Integer kbs[], Integer ne, Integer nka, const double a[],
                       const Integer ha[], const Integer ka[], double alpha, const double x[],
                       Integer lenx, double beta, double y[], Integer leny);
  extern void e04ugr  (Integer *inform, Integer jrep, Integer m, double z[],
                       Integer iw[], Integer leniw, double rw[], Integer lenrw);
  extern void e04ugs  (Integer nrealloc, Integer minfac,
                       Integer m, Integer n, Integer ne, Integer *miniw,
                       Integer minrw, Integer *liwest,
                       Integer *lrwest, Integer iw[], double nz_coef);
  extern void e04ugt  (const char *typelu, Boolean *needlu, Boolean *newlu, Boolean *newb,
                       Integer *ierror, Integer iobj, Integer itn,
                       Integer *lureq, Integer m, Integer mbs, Integer n,
                       Integer nb, Integer nnl, Integer *ns, Integer *nswap,
                       double *xnorm, Integer ne, Integer nka, const double a[],
                       const Integer ha[], const Integer ka[], Integer kbs[], Integer hs[],
                       const double b[], Integer lenb, const double bl[], const double bu[],
                       double blbs[], double bubs[], double xbs[], double xs[],
                       Integer iy[], Integer iy2[], double y[], double y2[],
                       Integer iw[], Integer leniw, double rw[], Integer lenrw, Nag_FileSt *stream, Nag_E04_Opt *opt);
  extern void e04ugu  (const char *job, Integer *inform, Integer lprint, Integer m,
                       Integer n, Integer nbs, Integer ne, Integer nka,
                       const double a[], const Integer ha[], const Integer ka[], const Integer kbs[],
                       Integer ip[], double alu[], Integer indc[], Integer indr[],
                       Integer lena, Integer iy[], Integer iy2[], double y[],
                       Integer iw[], Integer leniw, double rw[], Integer lenrw,
                       Integer itn, Nag_FileSt *stream);
  extern NAG_DLL_EXPIMP void NAG_CALL e04ugv  (const char *job, double tolz, Integer ne, Integer lenka,
                       const double a[], const Integer ha[], const Integer ka[], double alpha,
                       const double x[], Integer lenx, double beta, double y[],
                       Integer leny);
  extern void e04ugw  (Boolean *first, Boolean *done, Boolean *imprvd, Integer *inform,
                       Integer maxf, Integer *numf, double alfmax, double alfsml,
                       double epsaf, double g0, double targtg, double ftry,
                       double *tolabs, double tolrel, double toltny, double *alfa,
                       double *alfbst, double *fbest, Boolean *braktd, Boolean *crampd,
                       Boolean *extrap, Boolean *moved, Boolean *vset, Boolean *wset,
                       Integer *nsamea, Integer *nsameb, double *a, double *b,
                       double *fa, double *factor, double *xtry, double *xw,
                       double *fw, double *xv, double *fv, double *tolmax);
  extern void e04ugx  (Boolean *first, Boolean *done, Boolean *imprvd, Integer *inform,
                       Integer maxf, Integer *numf, double alfmax, double epsaf,
                       double g0, double targtg, double ftry, double gtry,
                       double *tolabs, double tolrel, double toltny, double *alfa,
                       double *alfbst, double *fbest, double *gbest, Boolean *braktd,
                       Boolean *crampd, Boolean *extrap, Boolean *moved, Boolean *wset,
                       Integer *nsamea, Integer *nsameb, double *a, double *b,
                       double *factor, double *xtry, double *xw, double *fw,
                       double *gw, double *tolmax);
  extern void e04ugy  (Boolean fp, double duinf, double fobj, double bigfx,
                       double objtru, Integer nmajor, Integer nminor, Integer ninf,
                       double sinf, Integer mminor, Integer *ierror, const Boolean ktcond[],
                       Integer itn, Integer itnlim, const Integer iw[], Integer leniw,
                       NagError *fail, Integer modier, Boolean linfea, Integer *ierr, Nag_FileSt *stream);
  extern void e04uhg  (Boolean feasbl, Boolean incres, Boolean *needpi, Boolean elastc,
                       Integer *ierror, Integer m1, Integer m, Integer nb,
                       Integer *ndegen, Integer *lureq, Integer *kp, Integer *jbq,
                       Integer *jsq, Integer *jbr, Integer *jsr, Integer jq,
                       double featol, double *pivot, double *step, double tolinc,
                       const Integer helast[], Integer hestat[], Integer hfeas[], Integer hs[],
                       Integer kbs[], const double bl[], const double bu[], double blbs[],
                       double bubs[], double xbs[], double xs[], double y[],
                       double y1[], Integer iw[], Integer leniw, double rw[],
                       Integer lenrw, Integer itn, Integer lprint, Nag_FileSt *stream);
   //cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04uhh  (const char *prbtyp, const char *contyp, Boolean *elastc, Boolean *needlu,
                       Boolean *needx, Integer *ierror, Integer m, Integer n,
                       Integer nb, Integer *ndegen, Integer itmax, Integer *itlp,
                       Integer *itn, Integer lemode, Integer lvlinf, Integer lprint,
                       Integer minimz, double objadd, Integer iobj, double tolfp,
                       double tollp, double tolx, Integer *ninf, double *sinf,
                       double wtinf, double *pinorm, double *rgnorm, double *xnorm,
                       Integer ne, Integer nka, const double a[], const Integer ha[],
                       const Integer ka[], const Integer helast[], Integer hestat[], Integer hfeas[],
                       Integer hs[], Integer kbs[], const double ascale[], const double b[],
                       Integer lenb, const double bl[], const double bu[], double blbs[],
                       double bubs[], double gbs[], double pi[], double rc[],
                       double xbs[], double xs[], Integer iy[], Integer iy2[],
                       double y[], double y2[], double y1[], char *cw,
                       Integer lencw, Integer iw[], Integer leniw, double rw[],
                       Integer lenrw, Nag_FileSt *stream, Nag_E04_Opt *opt);*/
  extern void e04uhh  (const char *prbtyp, const char *contyp, Boolean *elastc, Boolean *needlu,
                       Boolean *needx, Integer *ierror, Integer m, Integer n,
                       Integer nb, Integer *ndegen, Integer itmax, Integer *itlp,
                       Integer *itn, Integer lemode, Integer lvlinf, Integer lprint,
                       Integer minimz, double objadd, Integer iobj, double tolfp,
                       double tollp, double tolx, Integer *ninf, double *sinf,
                       double wtinf, double *pinorm, double *rgnorm, double *xnorm,
                       Integer ne, Integer nka, const double a[], const Integer ha[],
                       const Integer ka[], const Integer helast[], Integer hestat[], Integer hfeas[],
                       Integer hs[], Integer kbs[], const double ascale[], const double b[],
                       Integer lenb, const double bl[], const double bu[], double blbs[],
                       double bubs[], double gbs[], double dpi[], double rc[],
                       double xbs[], double xs[], Integer iy[], Integer iy2[],
                       double y[], double y2[], double y1[], char *cw,
                       Integer lencw, Integer iw[], Integer leniw, double rw[],
                       Integer lenrw, Nag_FileSt *stream, Nag_E04_Opt *opt);
  extern void e04uhj  (Integer nb, Integer nbs, const Integer hestat[], const Integer kbs[],
                       Integer *ninfe, double *sinfe, const double bl[], const double bu[],
                       const double xs[]);
  extern void e04uhk  (Integer nbs, double featol, Integer *ninf, double *sinf,
                       Integer hfeas[], const double blbs[], const double bubs[], double gbs[],
                       const double xbs[]);
  extern void e04uhl  (const char *pivot, Integer *ierror, Integer lenr, Integer m,
                       Integer maxr, Integer mbs, Integer nb, Integer *ns,
                       double hdmax, Integer hs[], Integer kbs[], Integer perm[],
                       const double bl[], const double bu[], double blbs[], double bubs[],
                       double xs[], double xbs[], double r[], const Integer iw[],
                       Integer leniw, const double rw[], Integer lenrw, Integer itn,
                       Integer lprint, Nag_FileSt *stream);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04uhm  (void (*hx)(void (*e04uls)(void),
                                  Integer , Integer , Integer , Integer ,
                                  Integer , const double [], const Integer [], const Integer [],
                                  const double [], double [], Integer , Nag_Comm *comm,
                                  char *cw, Integer , const Integer [],
                                  Integer , const double [], Integer ),
                       void (*hx1)(void),
                       Integer lenr, Integer minimz, Integer m, Integer mbs,
                       Integer n, Integer nb, Integer nnh, Integer ns,
                       Integer *nhx, Integer ne, Integer nka, const double a[],
                       const Integer ha[], const Integer ka[], double *hdmax, const Integer kbs[],
                       double r[], double v[], double w[], double y[],
                       Nag_Comm *comm, char *cw, Integer lencw,
                       Integer iw[], Integer leniw, double rw[], Integer lenrw);*/
  extern void e04uhm  (NAG_E04UHM2_FUN hx,
                       NAG_E04UHM1_FUN hx1,
                       Integer lenr, Integer minimz, Integer m, Integer mbs,
                       Integer n, Integer nb, Integer nnh, Integer ns,
                       Integer *nhx, Integer ne, Integer nka, const double a[],
                       const Integer ha[], const Integer ka[], double *hdmax, const Integer kbs[],
                       double r[], double v[], double w[], double y[],
                       Nag_Comm *comm, char *cw, Integer lencw,
                       Integer iw[], Integer leniw, double rw[], Integer lenrw);
  extern void e04uhn  (Boolean gotr, Integer lenr, Integer m, Integer mbs,
                       Integer n, Integer nb, Integer ns, Integer *jbsr,
                       Integer *lureq, double *pivot, Integer ne, Integer nka,
                       const double a[], const Integer ha[], const Integer ka[], Integer hs[],
                       Integer kbs[], double blbs[], double bubs[], double r[],
                       double xbs[], double y[], double y2[], double y1[],
                       Integer iw[], Integer leniw, double rw[], Integer lenrw,
                       Integer itn, Integer lprint, Boolean *kpeq0, Nag_FileSt *stream);
  extern void e04uhp  (Integer nbs, Integer ngobj, Integer ngobj0, Integer minimz,
                       const Integer kbs[], const double gobj[], double gbs[]);
  extern void e04uhq  (const char *type, Integer k, char *istate);
  extern void e04uhr  (Integer iprint, double bplus, double tolfea, double tolopt,
                       Integer *js, double d1, double d2, double *djtest,
                       Integer j, const char *id, double xj, double cj,
                       double b1, double b2, double dj, Integer k,
                       Integer number, double clamda, Integer n, Integer isumm,
                       double plinfy, Nag_FileSt *stream);
  //cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04uhs  (Integer minimz, Integer m, Integer n, Integer *nncon,
                       Integer nb, Integer nnobj, Integer ns,
                       Integer ninf, double sinf, Integer iobj, double pinorm,
                       Integer ne, Integer nka, const double a[], const Integer ha[],
                       const Integer ka[], const Integer hs[], const double ascale[], const double bl[],
                       const double bu[], const double gobj[], const double pi[], const double rc[],
                       const double xs[], const double y[], char **crnames, char *cw,
                       Integer lencw, const Integer iw[], Integer leniw, const double rw[],
                       Integer lenrw, Boolean dummy, Integer itn, Boolean linfea, Nag_FileSt *stream);*/
  extern void e04uhs  (Integer minimz, Integer m, Integer n, Integer *nncon,
                       Integer nb, Integer nnobj, Integer ns,
                       Integer ninf, double sinf, Integer iobj, double pinorm,
                       Integer ne, Integer nka, const double a[], const Integer ha[],
                       const Integer ka[], const Integer hs[], const double ascale[], const double bl[],
                       const double bu[], const double gobj[], const double dpi[], const double rc[],
                       const double xs[], const double y[], char **crnames, char *cw,
                       Integer lencw, const Integer iw[], Integer leniw, const double rw[],
                       Integer lenrw, Boolean dummy, Integer itn, Boolean linfea, Nag_FileSt *stream);
  extern void e04uht  (Integer j, Integer n, Integer nncon, Integer nb,
                       char **crnames, char *id, Integer iobj,
                       Boolean dummy, Nag_FileSt *stream);
  extern void e04uhu  (Integer m, Integer maxs, Integer mbs, Integer n,
                       Integer nb, Integer *ns, Integer iobj, Integer hs[],
                       Integer kbs[], const double bl[], const double bu[], double xs[],
                       const Integer iw[], Integer leniw, const double rw[], Integer lenrw, Nag_FileSt *stream);
  extern void e04uhx  (const char *job, Nag_Start start, Integer *iw, Integer leniw,
                       double *rw, Integer lenrw, Integer miniw, Integer minrw, Nag_FileSt *stream);
  extern void e04uhy  (Integer mbs, Integer m, Integer n, Integer nb,
                       Integer isumm, const double z[], const Integer ip[], const Integer iq[],
                       const double bl[], const double bu[], Integer hs[], const Integer kbs[],
                       double xs[], Integer lprint, Nag_FileSt *stream);
  extern void e04uhz  (Integer lprint, Integer m, Integer n, Integer nb,
                       Integer nnl, Integer nncon, Integer nnjac, const Integer hrtype[],
                       Integer ne, Integer nka, const double a[], const Integer ha[],
                       const Integer ka[], double ascale[], const double bl[], const double bu[],
                       double rmin[], double rmax[], const Integer iw[], Integer leniw,
                       const double rw[], Integer lenrw, Nag_FileSt *stream);
  //cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04ujg  (Integer m, Integer nbs, Integer n, Integer ns,
                       double tolz, const double gbs[], const double pi[], double rg[],
                       double *rgnorm, Integer ne, Integer nka, const double a[],
                       const Integer ha[], const Integer ka[], const Integer kbs[]);*/
  extern void e04ujg  (Integer m, Integer nbs, Integer n, Integer ns,
                       double tolz, const double gbs[], const double dpi[], double rg[],
                       double *rgnorm, Integer ne, Integer nka, const double a[],
                       const Integer ha[], const Integer ka[], const Integer kbs[]);
  //cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04ujh  (Integer j1, Integer j2, Boolean gotg, Integer m,
                       Integer n, Integer nng, Integer nng0, double sgnobj,
                       Integer ne, Integer nka, const double a[], const Integer ha[],
                       const Integer ka[], const Integer hs[], const double g[], const double pi[],
                       double rc[]);*/
  extern void e04ujh  (Integer j1, Integer j2, Boolean gotg, Integer m,
                       Integer n, Integer nng, Integer nng0, double sgnobj,
                       Integer ne, Integer nka, const double a[], const Integer ha[],
                       const Integer ka[], const Integer hs[], const double g[], const double dpi[],
                       double rc[]);
  //cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04ujj  (Integer j1, Integer j2, Boolean gotg, Integer m,
                       Integer n, Integer nng, Integer nng0, double sgnobj,
                       Integer ne, Integer nka, const double a[], const Integer ha[],
                       const Integer ka[], const Integer helast[], const Integer hs[], const double g[],
                       const double pi[], double rc[]);*/
  extern void e04ujj  (Integer j1, Integer j2, Boolean gotg, Integer m,
                       Integer n, Integer nng, Integer nng0, double sgnobj,
                       Integer ne, Integer nka, const double a[], const Integer ha[],
                       const Integer ka[], const Integer helast[], const Integer hs[], const double g[],
                       const double dpi[], double rc[]);
  //cheney change pi[] to dpi[]2006-6-5
  /*extern void e04ujk  (Boolean elastc, Boolean feasbl, Boolean *incres, Boolean gotg,
                       Integer itn, Integer m, Integer n, Integer nb,
                       Integer nng, Integer nng0, Integer nnh, Integer ns,
                       Integer *nonopt, double weight, double sgnobj, double pinorm,
                       Integer *jq, double *djq, Integer *kprc, double toldj[],
                       Integer ne, Integer nka, const double a[], const Integer ha[],
                       const Integer ka[], const Integer helast[], const Integer hs[], const double bl[],
                       const double bu[], const double g[], const double pi[], double rc[],
                       const Integer iw[], Integer leniw, const double rw[], Integer lenrw);*/
  extern void e04ujk  (Boolean elastc, Boolean feasbl, Boolean *incres, Boolean gotg,
                       Integer itn, Integer m, Integer n, Integer nb,
                       Integer nng, Integer nng0, Integer nnh, Integer ns,
                       Integer *nonopt, double weight, double sgnobj, double pinorm,
                       Integer *jq, double *djq, Integer *kprc, double toldj[],
                       Integer ne, Integer nka, const double a[], const Integer ha[],
                       const Integer ka[], const Integer helast[], const Integer hs[], const double bl[],
                       const double bu[], const double g[], const double dpi[], double rc[],
                       const Integer iw[], Integer leniw, const double rw[], Integer lenrw);
  extern void e04ujl  (const char *prbtyp, const char *contyp, Boolean elastc, Boolean gotr,
                       Boolean prtfea, Boolean jstfea, Boolean objphs, Integer m,
                       Integer mbs, Integer ns, Integer jsq, Integer jbr,
                       Integer jsr, Integer jbsr, Integer *lines1, Integer *lines2,
                       Integer itn, Integer kprc, Integer lvlinf, Integer lprint,
                       double sgnobj, double pivot, double step, Integer ninf,
                       double sinf, double wtinf, double obj, double condhz,
                       double djqprt, double rgnorm, const Integer kbs[], const double xbs[],
                       Integer iw[], Integer leniw, Nag_FileSt *stream);
  extern void e04ujm  (Integer nb, Integer nbs, double wtinf, const Integer hestat[],
                       const Integer kbs[], double gbs[]);
  extern void e04ujn  (Boolean objphs, Boolean gotr, Boolean posdef, Integer lenr,
                       Integer n, const double r[], const double g[], double d[],
                       double *gd, double *dhd);
  //cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04ujp  (Boolean needb, Integer *ierror, Integer lenb, Integer m,
                       Integer maxs, Integer mbs, Integer n, Integer nb,
                       Integer nncon, Integer *ns, Integer nscl, Integer *ndegen,
                       Integer numlc, Integer numleq, Integer numliq, Integer itmax,
                       Integer *itqp, Integer *itn, Integer lprint, double objadd,
                       double tolfp, double tolqp, double tolx, Integer *ninf,
                       double *sinf, double wtinf, double *pinorm, double *rgnorm,
                       double *xnorm, Integer ne, Integer nka, const double a[],
                       const Integer ha[], const Integer ka[], const Integer helast[], Integer hestat[],
                       Integer hfeas[], Integer hs[], Integer kbs[], const double ascale[],
                       const double b[], double bl[], double bu[], double blbs[],
                       double bubs[], const double blslk[], const double buslk[], double gbs[],
                       double pi[], double rc[], double rhs[], double xs[],
                       double xbs[], Integer iy[], Integer iy2[], double y[],
                       double y2[], double y1[], char *cw, Integer lencw,
                       Integer iw[], Integer leniw, double rw[], Integer lenrw,
                       Nag_FileSt *stream, Nag_E04_Opt *opt);*/
  extern void e04ujp  (Boolean needb, Integer *ierror, Integer lenb, Integer m,
                       Integer maxs, Integer mbs, Integer n, Integer nb,
                       Integer nncon, Integer *ns, Integer nscl, Integer *ndegen,
                       Integer numlc, Integer numleq, Integer numliq, Integer itmax,
                       Integer *itqp, Integer *itn, Integer lprint, double objadd,
                       double tolfp, double tolqp, double tolx, Integer *ninf,
                       double *sinf, double wtinf, double *pinorm, double *rgnorm,
                       double *xnorm, Integer ne, Integer nka, const double a[],
                       const Integer ha[], const Integer ka[], const Integer helast[], Integer hestat[],
                       Integer hfeas[], Integer hs[], Integer kbs[], const double ascale[],
                       const double b[], double bl[], double bu[], double blbs[],
                       double bubs[], const double blslk[], const double buslk[], double gbs[],
                       double dpi[], double rc[], double rhs[], double xs[],
                       double xbs[], Integer iy[], Integer iy2[], double y[],
                       double y2[], double y1[], char *cw, Integer lencw,
                       Integer iw[], Integer leniw, double rw[], Integer lenrw,
                       Nag_FileSt *stream, Nag_E04_Opt *opt);
  extern void e04ujq  (const char *task, Integer m, Integer maxs, Integer mbs,
                       Integer n, Integer nb, Integer *ns, Integer hs[],
                       Integer kbs[], const double bl[], const double bu[], double blbs[],
                       double bubs[], const double xs[], double xbs[]);
  extern void e04ujr  (const char *job, Integer *inform, Integer lprint, Integer nb,
                       Integer *ninf, Integer itn, double *featol, double tolx,
                       double *tolinc, const Integer hs[], const double bl[], const double bu[],
                       double xs[], Integer *itnfix, Integer nfix[], double *tolx0,
                       const Integer iw[], Integer leniw, const double rw[], Integer lenrw, Nag_FileSt *stream);
  extern void e04ujs  (Integer m, Integer mbs, Integer n, Integer nb,
                       Integer ns, Integer *kbsq, double *pivot, Integer ne,
                       Integer nka, const double a[], const Integer ha[], const Integer ka[],
                       const Integer kbs[], const double bl[], const double bu[], const double xbs[],
                       double y[], const Integer iw[], Integer leniw, const double rw[],
                       Integer lenrw, Integer itn, Integer lprint, Nag_FileSt *stream);
  extern void e04ujt  (Integer *inform, Integer nbs, Integer jqsave, const Integer kbs[],
                       double *gtd, double d[], const Integer iw[], Integer leniw,
                       Integer itn, Integer lprint, Nag_FileSt *stream);
  extern void e04uju  (Integer nb, Integer nbs, double plinfy, const Integer hestat[],
                       const Integer kbs[], const double bl[], const double bu[], double blbs[],
                       double bubs[]);
  extern void e04ujv  (Boolean *posdef, Integer *inform, Integer itn, Integer lenr,
                       Integer ns, double *drsq, const double r[], const Integer iw[],
                       Integer leniw, const double rw[], Integer lenrw, Integer lprint, Nag_FileSt *stream);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04ujw  (void (*hx)(void (*e04uls)(void),
                                  Integer , Integer , Integer , Integer ,
                                  Integer , const double [], const Integer [], const Integer [],
                                  const double [], double [], Integer , 
                                  Nag_Comm *comm, char *cw, Integer , const Integer [],
                                  Integer , const double [], Integer ),
                       void (*hx1)(void),
                       Integer *inform, Integer minimz, Integer jq, Integer jradd,
                       Integer lenr, Integer m, Integer mbs, Integer n,
                       Integer nb, Integer nnh, Integer ns, Integer *nhx,
                       Integer ne, Integer nka, const double a[], const Integer ha[],
                       const Integer ka[], const Integer kbs[], double r[], double v[],
                       double w[], const double y[], Nag_Comm *comm,
                       char *cw, Integer lencw, Integer iw[], Integer leniw,
                       double rw[], Integer lenrw);*/
  extern void e04ujw  (NAG_E04UJW2_FUN hx,
                       NAG_E04UJW1_FUN hx1,
                       Integer *inform, Integer minimz, Integer jq, Integer jradd,
                       Integer lenr, Integer m, Integer mbs, Integer n,
                       Integer nb, Integer nnh, Integer ns, Integer *nhx,
                       Integer ne, Integer nka, const double a[], const Integer ha[],
                       const Integer ka[], const Integer kbs[], double r[], double v[],
                       double w[], const double y[], Nag_Comm *comm,
                       char *cw, Integer lencw, Integer iw[], Integer leniw,
                       double rw[], Integer lenrw);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04ujx  (const char *prbtyp, const char *contyp, Boolean *elastc, Integer *ierror,
                       void (*hx)(void (*e04uls)(void),
                                  Integer , Integer , Integer , Integer ,
                                  Integer , const double [], const Integer [], const Integer [],
                                  const double [], double [], Integer ,
                                  Nag_Comm *, char *cw, Integer , const Integer [],
                                  Integer , const double [], Integer ),
                       void (*hx1)(void),
                       Boolean *gotr, Boolean *needlu, char *typelu, Boolean *needx,
                       Integer lenr, Integer lenx0, Integer m, Integer maxs,
                       Integer mbs, Integer n, Integer nb, Integer *ndegen,
                       Integer ngqp, Integer ngqp0, Integer ngobj, Integer ngobj0,
                       Integer nnh, Integer *ns, Integer *nhx, Integer itmax,
                       Integer *itqp, Integer *itn, Integer lemode, Integer lvlinf,
                       Integer lprint, Integer minimz, double objadd, double *objqp,
                       Integer iobj, double tolfp, double tolqp, double tolx,
                       Integer *ninf, double *sinf, double wtinf, double *pinorm,
                       double *rgnorm, double *xnorm, Integer ne, Integer nka,
                       const double a[], const Integer ha[], const Integer ka[], const Integer helast[],
                       Integer hestat[], Integer hfeas[], Integer hs[], Integer kbs[],
                       const double ascale[], const double b[], Integer lenb, const double bl[],
                       const double bu[], double blbs[], double bubs[], const double gobj[],
                       double gobjqp[], double gbs[], double pi[], double r[],
                       double rc[], double rg[], double xbs[], const double x0[],
                       double xs[], double xdif[], Integer iy[], Integer iy2[],
                       double y[], double y2[], double y1[], double t[],
                       Nag_Comm *comm, char *cw, Integer lencw,
                       Integer iw[], Integer leniw, double rw[], Integer lenrw, Nag_FileSt *stream, Nag_E04_Opt *opt);*/
  extern void e04ujx  (const char *prbtyp, const char *contyp, Boolean *elastc, Integer *ierror,
                       NAG_E04UJX2_FUN hx,
                       NAG_E04UJX1_FUN hx1,
                       Boolean *gotr, Boolean *needlu, char *typelu, Boolean *needx,
                       Integer lenr, Integer lenx0, Integer m, Integer maxs,
                       Integer mbs, Integer n, Integer nb, Integer *ndegen,
                       Integer ngqp, Integer ngqp0, Integer ngobj, Integer ngobj0,
                       Integer nnh, Integer *ns, Integer *nhx, Integer itmax,
                       Integer *itqp, Integer *itn, Integer lemode, Integer lvlinf,
                       Integer lprint, Integer minimz, double objadd, double *objqp,
                       Integer iobj, double tolfp, double tolqp, double tolx,
                       Integer *ninf, double *sinf, double wtinf, double *pinorm,
                       double *rgnorm, double *xnorm, Integer ne, Integer nka,
                       const double a[], const Integer ha[], const Integer ka[], const Integer helast[],
                       Integer hestat[], Integer hfeas[], Integer hs[], Integer kbs[],
                       const double ascale[], const double b[], Integer lenb, const double bl[],
                       const double bu[], double blbs[], double bubs[], const double gobj[],
                       double gobjqp[], double gbs[], double dpi[], double r[],
                       double rc[], double rg[], double xbs[], const double x0[],
                       double xs[], double xdif[], Integer iy[], Integer iy2[],
                       double y[], double y2[], double y1[], double t[],
                       Nag_Comm *comm, char *cw, Integer lencw,
                       Integer iw[], Integer leniw, double rw[], Integer lenrw, Nag_FileSt *stream, Nag_E04_Opt *opt);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04ujy  (void (*hx)(void (*e04uls)(void),
                                  Integer , Integer , Integer , Integer ,
                                  Integer , const double [], const Integer [], const Integer [],
                                  const double [], double [], Integer , Nag_Comm *,
                                  char *cw, Integer , const Integer [],
                                  Integer , const double [], Integer ),
                       void (*hx1)(void),
                       Integer minimz, Integer lenx0, Integer n, Integer ngqp,
                       Integer ngobj, Integer ngobj0, Integer nnh, Integer nstate,
                       Integer *nhx, double *objqp, Integer ne, Integer nka,
                       const double a[], const Integer ha[], const Integer ka[], const double gobj[],
                       double gobjqp[], const double x0[], const double x[], double xdif[],
                       Nag_Comm *comm, char *cw, Integer lencw,
                       const Integer iw[], Integer leniw, const double rw[], Integer lenrw);*/
  extern void e04ujy  (NAG_E04UJY2_FUN hx,
                       NAG_E04UJY1_FUN hx1,
                       Integer minimz, Integer lenx0, Integer n, Integer ngqp,
                       Integer ngobj, Integer ngobj0, Integer nnh, Integer nstate,
                       Integer *nhx, double *objqp, Integer ne, Integer nka,
                       const double a[], const Integer ha[], const Integer ka[], const double gobj[],
                       double gobjqp[], const double x0[], const double x[], double xdif[],
                       Nag_Comm *comm, char *cw, Integer lencw,
                       const Integer iw[], Integer leniw, const double rw[], Integer lenrw);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04ujz  (void (*hx)(void (*e04uls)(void),
                                  Integer , Integer , Integer , Integer ,
                                  Integer , const double [], const Integer [], const Integer [],
                                  const double [], double [], Integer , Nag_Comm *,
                                  char *cw, Integer , const Integer [],
                                  Integer , const double [], Integer ),
                       void (*hx1)(void),
                       Boolean *bndswp, Boolean elastc, Boolean feasbl, Boolean gotg,
                       Boolean goth, Boolean *gotr, Boolean * incres, Boolean objphs,
                       Boolean *needpi, Boolean newsb, Boolean *posdef, Integer *ierror,
                       Integer itn, Integer lenr, Integer m, Integer mbs,
                       Integer maxs, Integer n, Integer nb, Integer ngqp0,
                       Integer ngqp, Integer nnh, Integer *ns, Integer *ndegen,
                       Integer *nhx, Integer *lureq, Integer *kp, Integer *jbq,
                       Integer *jsq, Integer *jbr, Integer *jsr, Integer jq,
                       Integer *jqsave, Integer *nuncon, double djq, Integer minimz,
                       double *obj, double *objqp, double featol, double *pivot,
                       double *step, double tolinc, double wtinf, Integer ne,
                       Integer nka, const double a[], const Integer ha[], const Integer ka[],
                       const Integer helast[], Integer hestat[], Integer hfeas[], Integer hs[],
                       Integer kbs[], const double bl[], const double bu[], double blbs[],
                       double bubs[], double gbs[], double gobjqp[], double rg[],
                       double r[], double hy[], double xbs[], double xs[],
                       double y[], double y2[], double y1[], Nag_Comm * comm,
                       char *cw, Integer lencw, Integer iw[],
                       Integer leniw, double rw[], Integer lenrw, Integer lprint, Nag_FileSt *stream);*/
  extern void e04ujz  (NAG_E04UJZ1_FUN hx,
                       NAG_E04UJZ1_FUN hx1,
                       Boolean *bndswp, Boolean elastc, Boolean feasbl, Boolean gotg,
                       Boolean goth, Boolean *gotr, Boolean * incres, Boolean objphs,
                       Boolean *needpi, Boolean newsb, Boolean *posdef, Integer *ierror,
                       Integer itn, Integer lenr, Integer m, Integer mbs,
                       Integer maxs, Integer n, Integer nb, Integer ngqp0,
                       Integer ngqp, Integer nnh, Integer *ns, Integer *ndegen,
                       Integer *nhx, Integer *lureq, Integer *kp, Integer *jbq,
                       Integer *jsq, Integer *jbr, Integer *jsr, Integer jq,
                       Integer *jqsave, Integer *nuncon, double djq, Integer minimz,
                       double *obj, double *objqp, double featol, double *pivot,
                       double *step, double tolinc, double wtinf, Integer ne,
                       Integer nka, const double a[], const Integer ha[], const Integer ka[],
                       const Integer helast[], Integer hestat[], Integer hfeas[], Integer hs[],
                       Integer kbs[], const double bl[], const double bu[], double blbs[],
                       double bubs[], double gbs[], double gobjqp[], double rg[],
                       double r[], double hy[], double xbs[], double xs[],
                       double y[], double y2[], double y1[], Nag_Comm * comm,
                       char *cw, Integer lencw, Integer iw[],
                       Integer leniw, double rw[], Integer lenrw, Integer lprint, Nag_FileSt *stream);
  extern void e04ukg  (Integer n, const double bl[], const double bu[], const double x[],
                       double dx, double d[], Integer *nfeas);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04ukh  (Integer *ierror, Integer n, Integer nncon, Integer nnjac,
                       Integer nejac, Integer nb, 
                       void (*sfgcon)(Integer , Integer *, Integer , Integer ,
                                      Integer , Integer , Integer , 
                                      NAG_E04UGC_CONFUN fgcon,
                                      Integer ,
                                      Integer , const Integer [], const Integer [], double [],
                                      double [], double [], Nag_Comm *,
                                      char *cw, Integer , Integer [], Integer ,
                                      double [], Integer , Integer *),
                       NAG_E04UGC_CONFUN fgcon,
                       Integer ne, Integer nka, const Integer ha[], const Integer ka[],
                       const double bl[], const double bu[], const double f[], double f2[],
                       const double g[], double g2[], double x[], double y[],
                       double y2[], Nag_Comm * comm, char *cw,
                       Integer lencw, Integer iw[], Integer leniw, double rw[],
                       Integer lenrw, Integer *modier, Nag_FileSt *stream);*/
  extern void e04ukh  (Integer *ierror, Integer n, Integer nncon, Integer nnjac,
                       Integer nejac, Integer nb, 
                       NAG_E04UKH_FUN sfgcon,
                       NAG_E04UGC_CONFUN fgcon,
                       Integer ne, Integer nka, const Integer ha[], const Integer ka[],
                       const double bl[], const double bu[], const double f[], double f2[],
                       const double g[], double g2[], double x[], double y[],
                       double y2[], Nag_Comm * comm, char *cw,
                       Integer lencw, Integer iw[], Integer leniw, double rw[],
                       Integer lenrw, Integer *modier, Nag_FileSt *stream);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04ukj  (Integer *inform, Boolean elastc, Boolean fonly, Integer minimz,
                       Integer n, Integer nb, Integer nncon, Integer nncon0,
                       Integer nnobj, Integer nnobj0, Integer iobj, Integer itn,
                       void (*sfgcon)(Integer , Integer *, Integer , Integer ,
                                      Integer , Integer , Integer , 
                                      NAG_E04UGC_CONFUN fgcon,
                                      Integer ,
                                      Integer , const Integer [], const Integer [], double [],
                                      double [], double [], Nag_Comm *,
                                      char *cw, Integer , Integer [], Integer ,
                                      double [], Integer , Integer *),
                       NAG_E04UGC_CONFUN fgcon,
                       void (*sfgobj)(Integer , Integer *, Integer , Integer ,
                                      NAG_E04UGC_OBJFUN fgobj,
                                      double *, double [], double [], Nag_Comm *,
                                      char *cw, Integer , Integer [],
                                      Integer , double [], Integer , Integer *),
                       NAG_E04UGC_OBJFUN fgobj,
                       Integer ne, Integer nka, const double a[], const Integer ha[],
                       const Integer ka[], Integer nejac, Integer nkg, const Integer kg[],
                       double *fmrt, double gmrt, double ginf, double sinf,
                       double *sinf2, double wtinf, double *step, double stepmn,
                       double stepmx, double pnorm, double xnorm, double *fobj,
                       double fcon[], double gcon[], double gobj[], double tfcon[],
                       double tgcon[], double tgobj[], double xs[], double x2[],
                       const double p[], const double xmul[], double xmul2[], const double xdmul[],
                       const double xpen[], double w[], double y[], double y2[],
                       Nag_Comm *comm, char *cw, Integer lencw,
                       Integer iw[], Integer leniw, double rw[], Integer lenrw,
                       Integer *modier, Nag_FileSt *stream);*/
  extern void e04ukj  (Integer *inform, Boolean elastc, Boolean fonly, Integer minimz,
                       Integer n, Integer nb, Integer nncon, Integer nncon0,
                       Integer nnobj, Integer nnobj0, Integer iobj, Integer itn,
                       NAG_E04UKJ1_FUN sfgcon,
                       NAG_E04UGC_CONFUN fgcon,
                       NAG_E04UKJ2_FUN sfgobj,
                       NAG_E04UGC_OBJFUN fgobj,
                       Integer ne, Integer nka, const double a[], const Integer ha[],
                       const Integer ka[], Integer nejac, Integer nkg, const Integer kg[],
                       double *fmrt, double gmrt, double ginf, double sinf,
                       double *sinf2, double wtinf, double *step, double stepmn,
                       double stepmx, double pnorm, double xnorm, double *fobj,
                       double fcon[], double gcon[], double gobj[], double tfcon[],
                       double tgcon[], double tgobj[], double xs[], double x2[],
                       const double p[], const double xmul[], double xmul2[], const double xdmul[],
                       const double xpen[], double w[], double y[], double y2[],
                       Nag_Comm *comm, char *cw, Integer lencw,
                       Integer iw[], Integer leniw, double rw[], Integer lenrw,
                       Integer *modier, Nag_FileSt *stream);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04ukl   (Integer * ierror, Integer m, Integer n, Integer nncon,
                        Integer nncon0, Integer nnjac, Integer nejac, Integer nnl,
                        Integer nnobj, Integer nnobj0,
                        void (*sfgcon) (Integer, Integer *, Integer, Integer,
                                        Integer, Integer, Integer,
                                        NAG_E04UGC_CONFUN fgcon,
                                        Integer,
                                        Integer, const Integer[], const Integer[], double[],
                                        double[], double[], Nag_Comm *,
                                        char *cw, Integer, Integer[], Integer,
                                        double[], Integer, Integer *),
                        NAG_E04UGC_CONFUN fgcon,
                        void (*sfgobj) (Integer, Integer *, Integer, Integer,
                                        NAG_E04UGC_OBJFUN fgobj,
                                        double *, double[], double[], Nag_Comm *,
                                        char *cw, Integer, Integer[],
                                        Integer, double[], Integer, Integer *),
                        NAG_E04UGC_OBJFUN fgobj,
                        Integer ne, Integer nka, const Integer ha[], const Integer ka[],
                        double * fobj, double fcon[], double gcon[], double gobj[],
                        double x[], Nag_Comm *, char *cw,
                        Integer lencw, Integer iw[], Integer leniw, double rw[],
                        Integer lenrw, Integer * modier, Integer itn, Nag_FileSt *stream,
                        Integer *nstate);*/
  extern void e04ukl   (Integer * ierror, Integer m, Integer n, Integer nncon,
                        Integer nncon0, Integer nnjac, Integer nejac, Integer nnl,
                        Integer nnobj, Integer nnobj0,
                        NAG_E04UKL1_FUN sfgcon,
                        NAG_E04UGC_CONFUN fgcon,
                        NAG_E04UKL2_FUN sfgobj,
                        NAG_E04UGC_OBJFUN fgobj,
                        Integer ne, Integer nka, const Integer ha[], const Integer ka[],
                        double * fobj, double fcon[], double gcon[], double gobj[],
                        double x[], Nag_Comm *, char *cw,
                        Integer lencw, Integer iw[], Integer leniw, double rw[],
                        Integer lenrw, Integer * modier, Integer itn, Nag_FileSt *stream,
                        Integer *nstate);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04ukm  (Integer *ierror, Integer n, Integer nejac, Integer nnl,
                       Integer nncon, Integer nncon0, Integer nnjac, Integer nnobj,
                       Integer nnobj0, 
                       void (*sfgcon)(Integer , Integer *, Integer , Integer ,
                                      Integer , Integer , Integer , 
                                      NAG_E04UGC_CONFUN fgcon,
                                      Integer ,
                                      Integer , const Integer [], const Integer [], double [],
                                      double [], double [], Nag_Comm *,
                                      char *cw, Integer , Integer [], Integer ,
                                      double [], Integer , Integer *),
                       NAG_E04UGC_CONFUN fgcon,
                       void (*sfgobj)(Integer , Integer *, Integer , Integer ,
                                      NAG_E04UGC_OBJFUN fgobj,
                                      double *, double [], double [], Nag_Comm *,
                                      char *cw, Integer , Integer [],
                                      Integer , double [], Integer , Integer *),
                       NAG_E04UGC_OBJFUN fgobj,
                       Integer ne, Integer nka, const Integer ha[], const Integer ka[],
                       double fcon[], double fobj, double gcon[], double gobj[],
                       double x[], double w[], Nag_Comm * comm,
                       char *cw, Integer lencw, Integer iw[], Integer leniw,
                       double rw[], Integer lenrw, Integer *modier);*/
  extern void e04ukm  (Integer *ierror, Integer n, Integer nejac, Integer nnl,
                       Integer nncon, Integer nncon0, Integer nnjac, Integer nnobj,
                       Integer nnobj0, 
                       NAG_E04UKM1_FUN sfgcon,
                       NAG_E04UGC_CONFUN fgcon,
                       NAG_E04UKM2_FUN sfgobj,
                       NAG_E04UGC_OBJFUN fgobj,
                       Integer ne, Integer nka, const Integer ha[], const Integer ka[],
                       double fcon[], double fobj, double gcon[], double gobj[],
                       double x[], double w[], Nag_Comm * comm,
                       char *cw, Integer lencw, Integer iw[], Integer leniw,
                       double rw[], Integer lenrw, Integer *modier);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04ukn  (Integer *ierror, Integer nnobj, 
                       void (*sfgobj) (Integer, Integer *, Integer, Integer,
                                       NAG_E04UGC_OBJFUN fgobj,
                                       double *, double[], double[], Nag_Comm *,
                                       char *cw, Integer, Integer[],
                                       Integer, double[], Integer, Integer *),
                       NAG_E04UGC_OBJFUN fgobj,
                       double fobj, double gobj[], double gobju[], double x[],
                       Nag_Comm * comm, char *cw, Integer lencw,
                       Integer iw[], Integer leniw, double rw[], Integer lenrw,
                       Integer *modier);*/
   extern void e04ukn  (Integer *ierror, Integer nnobj, 
                       NAG_E04UKN_FUN sfgobj,
                       NAG_E04UGC_OBJFUN fgobj,
                       double fobj, double gobj[], double gobju[], double x[],
                       Nag_Comm * comm, char *cw, Integer lencw,
                       Integer iw[], Integer leniw, double rw[], Integer lenrw,
                       Integer *modier);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04ukp  (Integer *ierror, Integer n, Integer nncon, Integer nnjacp,
                       Integer nejac, 
                       void (*sfgcon)(Integer , Integer *, Integer , Integer ,
                                      Integer , Integer , Integer , 
                                      NAG_E04UGC_CONFUN fgcon,
                                      Integer ,
                                      Integer , const Integer [], const Integer [], double [],
                                      double [], double [], Nag_Comm *,
                                      char *cw, Integer , Integer [], Integer ,
                                      double [], Integer , Integer *),
                       NAG_E04UGC_CONFUN fgcon,
                       Integer ne, Integer nka, const Integer ha[], const Integer ka[],
                       double fcon[], double fcon2[], double gcon[], double gconu[],
                       double x[], double y[], Nag_Comm *,
                       char *cw, Integer lencw, Integer iw[], Integer leniw,
                       double rw[], Integer lenrw, Integer *modier);*/
  extern void e04ukp  (Integer *ierror, Integer n, Integer nncon, Integer nnjacp,
                       Integer nejac, 
                       NAG_E04UKP_FUN sfgcon,
                       NAG_E04UGC_CONFUN fgcon,
                       Integer ne, Integer nka, const Integer ha[], const Integer ka[],
                       double fcon[], double fcon2[], double gcon[], double gconu[],
                       double x[], double y[], Nag_Comm *,
                       char *cw, Integer lencw, Integer iw[], Integer leniw,
                       double rw[], Integer lenrw, Integer *modier);
  extern void e04ukq  (const char *pivot, Integer *inform, Integer n, double hdmin,
                       double *dmax_, Integer *irank, Integer perm[], Integer lenh,
                       double h[]);
  extern void e04ukr  (Integer nr, Integer lenr, double r[], double v[],
                       const double w[], Integer lastv);
  extern void e04uks  (const char *job, Integer lenr, Integer nr, const double r[],
                       double y[]);
  extern void e04ukt  (Integer n, Integer lenr, double r[], double v[],
                       const double w[], Integer lastv, double vnorm, double tolz);
  extern void e04uku  (Integer jq, Integer jr, double eps, Integer lenr,
                       Integer nr, double r[], double w[]);
  extern void e04ukv  (Integer nr, Integer lenr, const double r[], double *drmax,
                       double *drmin, double *rmax, double *condh);
  extern void e04ukw  (Integer nbs, Integer *ndegen, double featol, double plinfy,
                       double stepmx, double tolinc, double tolpiv, const Integer hfeas[],
                       const double blbs[], const double bubs[], const double xbs[], const double y[],
                       Boolean *hitlow, Boolean *move, Boolean *onbnd, Boolean *unbndd,
                       Integer *kp, double *bound, double *exact, double *alpha,
                       double *alphap);
  extern void e04ukx  (const char *job, Integer *inform, Integer itn, Integer m,
                       Integer n, Integer nb, Integer nbs, double *rowerr,
                       double *xnorm, Integer ne, Integer nka, const double a[],
                       const Integer ha[], const Integer ka[], const double b[], Integer lenb,
                       const Integer kbs[], double xbs[], double xs[], double y2[],
                       double y[], Integer iw[], Integer leniw, double rw[],
                       Integer lenrw, Integer lprint, Nag_FileSt *stream);
  //cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04uky  (Integer m, double *pinorm, double rhs[], double pi[],
                       Integer iw[], Integer leniw, double rw[], Integer lenrw);*/
  extern void e04uky  (Integer m, double *pinorm, double rhs[], double dpi[],
                       Integer iw[], Integer leniw, double rw[], Integer lenrw);
  extern void e04ukz  (Integer nb, Integer nbs, double featol, double plinfy,
                       const Integer helast[], Integer hestat[], const Integer kbs[], const double bl[],
                       const double bu[], double blbs[], double bubs[], const double xbs[]);
  extern void e04ulg  (Integer modefg, Integer *ierror, Integer nstate, Integer nnobj,
                       NAG_E04UGC_OBJFUN fgobj,
                       double *fobj, double gobj[], double x[],
                       Nag_Comm * comm, char *cw, Integer lencw, Integer iw[],
                       Integer leniw, double rw[], Integer lenrw, Integer *modier);
  extern void e04ulh  (char *reset, Integer nnl, Integer *nqnmod, Integer mflush,
                       Integer *nflush, Integer *nskip, double h0[]);
  extern void e04ulj  (const char *task, double tolz, Integer ne, Integer nka,
                       const Integer ha[], const Integer ka[], Integer nejac, Integer nkg,
                       const double gcon[], const Integer kg[], double alpha, const double x[],
                       Integer lenx, double beta, double y[], Integer leny);
  extern void e04ulk  (Integer nncon, Integer nnjac, Integer ne, Integer nka,
                       const Integer ha[], const Integer ka[], Integer nejac1, Integer nkg1,
                       const double gcon1[], const Integer kg1[], Integer nejac2, Integer nkg2,
                       double gcon2[], const Integer kg2[]);
  extern void e04ull  (Boolean elastc, Integer n, Integer nb, Integer nncon,
                       Integer nncon0, double wtinf, double *prinf, double *duinf,
                       Integer *jprinf, Integer *jduinf, const double bl[], const double bu[],
                       const double rc[], const double xs[], const double y[]);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04ulm  (void (*e04uls)(void),
                       Integer minimz, Integer n, Integer nnl, Integer ne,
                       Integer nka, const double a[], const Integer ha[], const Integer ka[],
                       const double x[], double hx[], Integer nstate, Nag_Comm *comm,
                       char *cw, Integer lencw, const Integer iw[],
                       Integer leniw, const double rw[], Integer lenrw);*/
  extern void e04ulm  (NAG_E04ULM_FUN e04uls,
                       Integer minimz, Integer n, Integer nnl, Integer ne,
                       Integer nka, const double a[], const Integer ha[], const Integer ka[],
                       const double x[], double hx[], Integer nstate, Nag_Comm *comm,
                       char *cw, Integer lencw, const Integer iw[],
                       Integer leniw, const double rw[], Integer lenrw);
  extern void e04uln  (char *qnmsg, char *reset, Integer nnl, Integer nncon,
                       double step, double yp, double ypmin, double *php,
                       double hp[], const double y[], Integer iw[], Integer leniw,
                       double rw[], Integer lenrw);
  extern void e04ulp  (Integer nnl, Integer *minrw, Integer iw[]);
  extern void e04ulq  (Integer nncon, Integer nnjac, double tolz, Integer ne,
                       Integer nka, const Integer ha[], const Integer ka[], Integer nejac,
                       Integer nkg, const Integer kg[], double *curvl, double curvmn,
                       double *penunm, double step, const double fcon1[], const double fcon2[],
                       const double gcon1[], const double gcon2[], const double xdif[], double gdif[],
                       double penu[], double v[], double w[]);
  //cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04ulr  (Integer minimz, Integer m, Integer nncon, Integer nnobj,
                       Integer nnobj0, Integer nnjac, Integer nnl, double tolz,
                       Integer ne, Integer nka, const Integer ha[], const Integer ka[],
                       Integer nejac, Integer nkg, const Integer kg[], double *curvl,
                       const double gobj1[], const double gobj2[], const double gcon1[], const double gcon2[],
                       const double xdif[], double gdif[], const double pi[]);*/
  extern void e04ulr  (Integer minimz, Integer m, Integer nncon, Integer nnobj,
                       Integer nnobj0, Integer nnjac, Integer nnl, double tolz,
                       Integer ne, Integer nka, const Integer ha[], const Integer ka[],
                       Integer nejac, Integer nkg, const Integer kg[], double *curvl,
                       const double gobj1[], const double gobj2[], const double gcon1[], const double gcon2[],
                       const double xdif[], double gdif[], const double dpi[]);
  extern void e04uls  (void);
  extern void e04ult  (char *reset, Integer nnl, Integer iw[], Integer leniw,
                       double rw[], Integer lenrw);
  extern void e04ulu  (char *qnmsg, char *reset, Integer lenh, Integer nnl,
                       Integer nncon, Integer mqnmod, Integer *nqnmod, Integer mskip,
                       Integer *nskip, Integer *nflush, double *h0scal, double step,
                       double yp, double ypmin, double *php, double h[],
                       double hp[], const double y[]);
  extern void e04ulv  (Integer nnl, Integer *minrw, Integer iw[]);
  extern void e04ulw  (Integer n, Integer lenh, const double h[], const double x[],
                       double hx[]);
  extern void e04ulx  (char *reset, Integer nnl, Integer *nqnmod, Integer mflush,
                       Integer *nflush, Integer *nskip, double h[], Integer lenh);
  extern void e04uly  (Integer lenr, Integer n, Integer nfull, double ys,
                       double php, double r[], double hp[], const double y[],
                       double rp[]);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04ulz  (Integer *ierror, Integer nnobj, 
                       void (*sfgobj)(Integer , Integer *, Integer , Integer ,
                                      NAG_E04UGC_OBJFUN fgobj,
                                      double *, double [], double [], Nag_Comm *,
                                      char *cw, Integer , Integer [],
                                      Integer , double [], Integer , Integer *),
                       NAG_E04UGC_OBJFUN fgobj,
                       const double bl[], const double bu[], double f, const double g[],
                       double g2[], double x[], double da[], double db[],
                       Nag_Comm *, char *cw, Integer lencw,
                       Integer iw[], Integer leniw, double rw[], Integer lenrw,
                       Integer *modier, Nag_FileSt *stream);*/
  extern void e04ulz  (Integer *ierror, Integer nnobj, 
                       NAG_E04ULZ_FUN sfgobj,
                       NAG_E04UGC_OBJFUN fgobj,
                       const double bl[], const double bu[], double f, const double g[],
                       double g2[], double x[], double da[], double db[],
                       Nag_Comm *, char *cw, Integer lencw,
                       Integer iw[], Integer leniw, double rw[], Integer lenrw,
                       Integer *modier, Nag_FileSt *stream);
  extern void e04umg  (Integer nncon, Integer nnjac, Integer nejac, Integer n,
                       Integer ne, Integer nka, const double ascale[], const Integer ha[],
                       const Integer ka[], double gcon[], const Integer iw[], Integer leniw,
                       const double rw[], Integer lenrw);
  //cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04umh  (const char *job, Integer ierror, Integer minimz, Integer m,
                       Integer n, Integer nb, Integer nnl,
                       Integer ns, Integer nscl, double *sclobj, Integer itn,
                       Integer ninf, double sinf, double wtinf, Integer iobj,
                       double objtru, double *vimax, double *pnorm1, double *pnorm2,
                       double *pinorm, double *xnorm, Integer ne, Integer nka,
                       double a[], const Integer ha[], const Integer ka[], const Integer hestat[],
                       const Integer hs[], const double ascale[], double bl[], double bu[],
                       char **crnames, double pi[], double rc[], double xs[],
                       double y[], char *cw, Integer lencw, const Integer iw[],
                       Integer leniw, double rw[], Integer lenrw, Boolean dummy,
                       const char *prbtyp, Boolean linfea, double *xnorm1, Integer *jbinf,
                       Integer *jbinf1, double *binf, double *binf1, Integer *jdinf,
                       Integer *jdinf1, double *dinf, double *dinf1,
                       Nag_FileSt *stream, Boolean going2restart);*/
  extern void e04umh  (const char *job, Integer ierror, Integer minimz, Integer m,
                       Integer n, Integer nb, Integer nnl,
                       Integer ns, Integer nscl, double *sclobj, Integer itn,
                       Integer ninf, double sinf, double wtinf, Integer iobj,
                       double objtru, double *vimax, double *pnorm1, double *pnorm2,
                       double *pinorm, double *xnorm, Integer ne, Integer nka,
                       double a[], const Integer ha[], const Integer ka[], const Integer hestat[],
                       const Integer hs[], const double ascale[], double bl[], double bu[],
                       char **crnames, double dpi[], double rc[], double xs[],
                       double y[], char *cw, Integer lencw, const Integer iw[],
                       Integer leniw, double rw[], Integer lenrw, Boolean dummy,
                       const char *prbtyp, Boolean linfea, double *xnorm1, Integer *jbinf,
                       Integer *jbinf1, double *binf, double *binf1, Integer *jdinf,
                       Integer *jdinf1, double *dinf, double *dinf1,
                       Nag_FileSt *stream, Boolean going2restart);
  extern void e04umj  (Integer n, Integer nb, Integer nncon, double tolx,
                       Integer *ninf, double *sinf, const double bl[], const double bu[],
                       const double xs[]);
  //cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04umk  (double sclobj, Integer minimz, Integer iobj, Integer m,
                       Integer n, Integer nb, Integer nnobj, Integer nnobj0,
                       Integer nncon, Integer nnjac, Integer nejac, Integer ne,
                       Integer nka, const double a[], const Integer ha[], const Integer ka[],
                       const double gobj[], const double gcon[], const double pi[], double rc[]);*/
  extern void e04umk  (double sclobj, Integer minimz, Integer iobj, Integer m,
                       Integer n, Integer nb, Integer nnobj, Integer nnobj0,
                       Integer nncon, Integer nnjac, Integer nejac, Integer ne,
                       Integer nka, const double a[], const Integer ha[], const Integer ka[],
                       const double gobj[], const double gcon[], const double dpi[], double rc[]);
  extern void e04uml  (Integer n, Integer nncon, Integer nnjac, double tolz,
                       Integer *maxvi, double *vimax, double *virel, double *xnorm,
                       Integer ne, Integer nka, const double a[], const Integer ha[],
                       const Integer ka[], const double bl[], const double bu[], const double fcon[],
                       const double xs[], double y[]);
  extern void e04umm  (Integer nncon, double *f, double *gtp, double php,
                       Boolean *incrun, double *pendmp, double penmax, double *pennrm,
                       const double viol[], const double xmul[], const double xdmul[], double xpen[],
                       double y[], const double rw[], Integer lenrw);
  extern void e04umn  (const char *mjrmsg, const Boolean ktcond[], Integer mjrprt, Integer minimz,
                       Integer n, Integer nb, Integer nncon0, Integer ns,
                       Integer nmajor, Integer nminor, Integer nswap, double condhz,
                       Integer iobj, double objadd, double fmrt, double pennrm,
                       double step, double prinf, double duinf, double vimax,
                       double virel, Integer ne, Integer nka, const double a[],
                       const Integer ha[], const Integer ka[], const Integer hs[], const double ascale[],
                       const double bl[], const double bu[], const double fcon[], const double xmul[],
                       const double xs[], Integer iw[], Integer leniw, const double rw[],
                       Integer lenrw, Nag_FileSt *stream);
   //cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04ump  (char *reset, char *qpmsg, Boolean *elastc, Boolean *gotr,
                       Integer *ierror, Integer *itn, Integer lenr, Integer m,
                       Integer maxs, Integer mbs, Integer n, Integer nb,
                       Integer nnl, Integer nnl0, Integer nncon, Integer nnobj,
                       Integer nnobj0, Integer *ns, Integer *nhx, Integer *nminor,
                       Integer *ndegen, Integer *mjrprt, Integer mnrprt, Integer minimz,
                       double objadd, double *fobjqp, Integer iobj, double tolfp,
                       double tolqp, double tolx, Integer *ninf, double *sinf,
                       double wtinf, double *pinorm, double *xnorm, Integer ne,
                       Integer nka, const double a[], const Integer ha[], const Integer ka[],
                       const Integer helast[], Integer hestat[], Integer hfeas[], Integer hs[],
                       Integer kbs[], const double bl[], const double bu[], double blbs[],
                       double bubs[], const double gobj[], double pi[], double r[],
                       double rc[], const double x0[], double xs[], double xbs[],
                       double xdif[], double xsfeas[], Integer iy[], Integer iy2[],
                       double t[], double y[], double y1[], double y2[],
                       Nag_Comm *comm, char *cw, Integer lencw,
                       Integer iw[], Integer leniw, double rw[], Integer lenrw, Nag_FileSt *stream, Nag_E04_Opt *opt);*/
  extern void e04ump  (char *reset, char *qpmsg, Boolean *elastc, Boolean *gotr,
                       Integer *ierror, Integer *itn, Integer lenr, Integer m,
                       Integer maxs, Integer mbs, Integer n, Integer nb,
                       Integer nnl, Integer nnl0, Integer nncon, Integer nnobj,
                       Integer nnobj0, Integer *ns, Integer *nhx, Integer *nminor,
                       Integer *ndegen, Integer *mjrprt, Integer mnrprt, Integer minimz,
                       double objadd, double *fobjqp, Integer iobj, double tolfp,
                       double tolqp, double tolx, Integer *ninf, double *sinf,
                       double wtinf, double *pinorm, double *xnorm, Integer ne,
                       Integer nka, const double a[], const Integer ha[], const Integer ka[],
                       const Integer helast[], Integer hestat[], Integer hfeas[], Integer hs[],
                       Integer kbs[], const double bl[], const double bu[], double blbs[],
                       double bubs[], const double gobj[], double dpi[], double r[],
                       double rc[], const double x0[], double xs[], double xbs[],
                       double xdif[], double xsfeas[], Integer iy[], Integer iy2[],
                       double t[], double y[], double y1[], double y2[],
                       Nag_Comm *comm, char *cw, Integer lencw,
                       Integer iw[], Integer leniw, double rw[], Integer lenrw, Nag_FileSt *stream, Nag_E04_Opt *opt);
   //cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04umq  (Integer n, Integer nb, Integer nncon, const Integer hs[],
                       const double bl[], const double bu[], double pi[]);*/
  extern void e04umq  (Integer n, Integer nb, Integer nncon, const Integer hs[],
                       const double bl[], const double bu[], double dpi[]);
  //cheney change pi[] to dpi[] 2006-6-5
  /*extern void e04umr  (Integer *ierror, Integer m, Integer mbs, Integer n,
                       Integer nb, Integer nncon, Integer nnl, Integer nscl,
                       Integer *ndegen, Integer numlc, Integer numliq, Integer *itn,
                       Integer itnlim, Integer *itqp, Integer mnrprt, double tolqp,
                       double tolx, Integer *ninf, double *sinf, double wtinf,
                       double *pinorm, double *rgnorm, Integer ne, Integer nka,
                       const double a[], const Integer ha[], const Integer ka[], Integer helast[],
                       Integer hestat[], Integer hfeas[], Integer hs[], Integer kbs[],
                       const double ascale[], double rhs[], double bl[], double bu[],
                       const double bltru[], const double butru[], double blbs[], double bubs[],
                       double gbs[], double pi[], double rc[], const double x0[],
                       double xs[], double xbs[], Integer iy[], Integer iy2[],
                       double y[], double y1[], double y2[], char *cw,
                       Integer lencw, Integer iw[], Integer leniw, double rw[],
                       Integer lenrw, Nag_FileSt *stream, Nag_E04_Opt *opt);*/
  extern void e04umr  (Integer *ierror, Integer m, Integer mbs, Integer n,
                       Integer nb, Integer nncon, Integer nnl, Integer nscl,
                       Integer *ndegen, Integer numlc, Integer numliq, Integer *itn,
                       Integer itnlim, Integer *itqp, Integer mnrprt, double tolqp,
                       double tolx, Integer *ninf, double *sinf, double wtinf,
                       double *pinorm, double *rgnorm, Integer ne, Integer nka,
                       const double a[], const Integer ha[], const Integer ka[], Integer helast[],
                       Integer hestat[], Integer hfeas[], Integer hs[], Integer kbs[],
                       const double ascale[], double rhs[], double bl[], double bu[],
                       const double bltru[], const double butru[], double blbs[], double bubs[],
                       double gbs[], double dpi[], double rc[], const double x0[],
                       double xs[], double xbs[], Integer iy[], Integer iy2[],
                       double y[], double y1[], double y2[], char *cw,
                       Integer lencw, Integer iw[], Integer leniw, double rw[],
                       Integer lenrw, Nag_FileSt *stream, Nag_E04_Opt *opt);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04ums  (Boolean fp, Integer *ierror, Integer iobj, Integer *itn,
                       Integer lenr, Integer m, Integer maxs, Integer mbs,
                       Integer n, Integer nb, Integer *ns, Integer nncon,
                       Integer nncon0, Integer nnobj, Integer nnobj0, Integer nnl,
                       Integer nnl0, Integer *nmajor, Integer *nminor, Integer *ndegen,
                       void (*sfgcon)(Integer , Integer *, Integer , Integer ,
                                      Integer , Integer , Integer , 
                                      NAG_E04UGC_CONFUN fgcon,
                                      Integer ,
                                      Integer , const Integer [], const Integer [], double [],
                                      double [], double [], Nag_Comm *,
                                      char *cw, Integer , Integer [], Integer ,
                                      double [], Integer , Integer *),
                       NAG_E04UGC_CONFUN fgcon,
                       void (*sfgobj)(Integer , Integer *, Integer , Integer ,
                                      NAG_E04UGC_OBJFUN fgobj,
                                      double *, double [], double [], Nag_Comm *,
                                      char *cw, Integer , Integer [],
                                      Integer , double [], Integer , Integer *),
                       NAG_E04UGC_OBJFUN fgobj,
                       double *duinf, Integer minimz, double objadd, double *fobj,
                       double *fmrt, double *vimax, double *virel, double visup,
                       Integer *ninf, double *sinf, double wtinf0, double *wtinf,
                       double *pennrm, double *pinorm, double *xnorm, Integer ne,
                       Integer nka, double a[], const Integer ha[], const Integer ka[],
                       Integer nejac, Integer nkg, const Integer kg[], const Integer helast[],
                       Integer hestat[], Integer hfeas[], Integer hs[], Integer kbs[],
                       const double bl[], const double bu[], double blbs[], double bubs[],
                       double fcon[], double gcon[], double gobj[], double viol[],
                       double yslk[], double fcon1[], double gobj1[], double fcon2[],
                       double gcon2[], double gobj2[], double gdif[], double hp[],
                       double pi[], double r[], double rc[], double xs[],
                       double x2[], double xbs[], double xdif[], double xsfeas[],
                       double xmul[], double xmul2[], double xdmul[], double xpen[],
                       Integer iy[], Integer iy2[], double y[], double y1[],
                       double y2[], double w[], Nag_Comm *comm,
                       char *cw, Integer lencw, Integer iw[], Integer leniw,
                       double rw[], Integer lenrw, Boolean ktcond[], Integer *modier,
                       char *prbtyp, Nag_FileSt *stream, Nag_E04_Opt *opt);*/
  extern void e04ums  (Boolean fp, Integer *ierror, Integer iobj, Integer *itn,
                       Integer lenr, Integer m, Integer maxs, Integer mbs,
                       Integer n, Integer nb, Integer *ns, Integer nncon,
                       Integer nncon0, Integer nnobj, Integer nnobj0, Integer nnl,
                       Integer nnl0, Integer *nmajor, Integer *nminor, Integer *ndegen,
                       NAG_E04UMS1_FUN sfgcon,
                       NAG_E04UGC_CONFUN fgcon,
                       NAG_E04UMS2_FUN sfgobj,
                       NAG_E04UGC_OBJFUN fgobj,
                       double *duinf, Integer minimz, double objadd, double *fobj,
                       double *fmrt, double *vimax, double *virel, double visup,
                       Integer *ninf, double *sinf, double wtinf0, double *wtinf,
                       double *pennrm, double *pinorm, double *xnorm, Integer ne,
                       Integer nka, double a[], const Integer ha[], const Integer ka[],
                       Integer nejac, Integer nkg, const Integer kg[], const Integer helast[],
                       Integer hestat[], Integer hfeas[], Integer hs[], Integer kbs[],
                       const double bl[], const double bu[], double blbs[], double bubs[],
                       double fcon[], double gcon[], double gobj[], double viol[],
                       double yslk[], double fcon1[], double gobj1[], double fcon2[],
                       double gcon2[], double gobj2[], double gdif[], double hp[],
                       double dpi[], double r[], double rc[], double xs[],
                       double x2[], double xbs[], double xdif[], double xsfeas[],
                       double xmul[], double xmul2[], double xdmul[], double xpen[],
                       Integer iy[], Integer iy2[], double y[], double y1[],
                       double y2[], double w[], Nag_Comm *comm,
                       char *cw, Integer lencw, Integer iw[], Integer leniw,
                       double rw[], Integer lenrw, Boolean ktcond[], Integer *modier,
                       char *prbtyp, Nag_FileSt *stream, Nag_E04_Opt *opt);
  extern void e04umt  (const char *job, Integer nb, Integer *inform, Integer ne,
                       Integer nka, double a[], const Integer ha[], const Integer ka[],
                       const double bl[], const double bu[], double xs[], Integer iw[],
                       Integer leniw, double rw[], Integer lenrw);
  extern void e04umu  (const char *job, Integer lvlder, Integer nncon, Integer nnjac,
                       Integer nb, Integer *inform, Integer ne, Integer nka,
                       double a[], const Integer ha[], const Integer ka[], Integer nejac,
                       Integer nkg, double gcon[], Integer kg[], const double bl[],
                       const double bu[], double gconu[], double gcon2[], double xs[]);
  extern void e04umv  (char *qnmsg, Integer lenr, Integer m, Integer n,
                       Integer nbs, Integer nnl, Integer ns, double ys,
                       double php, Integer ne, Integer nka, const double a[],
                       const Integer ha[], const Integer ka[], const Integer kbs[], const double gdif[],
                       const double hp[], double r[], double w[], double y[],
                       double y2[], Integer iw[], Integer leniw, double rw[],
                       Integer lenrw);
  extern void e04umw  (Integer nrealloc, Integer minfac, Integer m, Integer n,
                       Integer ne, Integer nejac, Integer nncon, Integer nnjac,
                       Integer nnobj, Integer maxr, Integer maxs,
                       Integer *miniw, Integer *minrw, Integer iw[], double nz_coef);
  extern void e04umx_f(char *qnmsg, char *reset, Integer nnl, Integer nncon,
                       Integer mqnmod, Integer *nqnmod, Integer mskip, Integer *nskip,
                       Integer *nflush, double *h0scal, double step, double yp,
                       double ypmin, double *php, double hp[], const double y[],
                       double h0[], double gdif[], double hxdif[], double yts[],
                       double pthp[]);
  extern void e04umy  (Integer nnl, Integer *minrw, Integer iw[]);
  extern void e04umz_f(Integer nnl, const double x[], double hx[], Integer mqnmod,
                       Integer nqnmod, const double h0[], const double gdif[], const double hxdif[],
                       const double yts[], const double pthp[]);
  extern NAG_DLL_EXPIMP void NAG_CALL 
  e04unc(Integer m, Integer n, Integer nclin, Integer ncnlin, 
         double a[], Integer tda, double bl[], 
         double bu[], double y[], NAG_E04UNC_OBJFUN objfun, 
         NAG_E04UNC_CONFUN confun, double x[], double *objf,
         double f[], double fjac[], Integer tdfju, 
         Nag_E04_Opt *options, Nag_Comm *user_comm,
         NagError *fail);
  void e04unp(Integer mode, Integer n, Integer m,  double y[],
              double f[], double fjac[],  Integer tdfj,
              double *objf, double grad[], double yf[]);
  void e04unt(Boolean needfd,  Integer *inform, Integer m, Integer n,
              Integer ncnln, Integer tdcj, Integer tdcju, Integer tdfj,
              Integer tdfju, Integer *nfun, Integer *ngrad, Integer needc[],
              NAG_E04UNC_CONFUN confun, NAG_E04UNC_OBJFUN objfun,  double *alfa,
              double *alfbnd, double *alfmax, double alfsml,
              double dxnorm, double epsrf, double eta,
              double *gdx, double grdalf, double gl1, double *gl,
              double *objf, double *objalf, double curvqp,
              double xnorm, double c[], double cjac[],
              double cjacu[], double cjdx[], double cmul1[],
              double cmul[], double cs1[], double cs[],
              double dx[], double dlam[], double dslk[],
              double y[], double f[], double fjac[],
              double fjacu[], double grad[], double gradu[],
              double qpmul[], double rho[], double slk1[],
              double slk[], double x1[], double x[], double w[],
              Nag_ae04nc *ae04nc, Nag_ae04uc *ae04uc, Nag_ae04up *ae04up,
              Nag_de04uc *de04uc, Nag_Comm *comm);
  void e04unv(Integer m, Integer n, Integer *litotl, Integer *lwtotl, 
              Nag_ae04up *ae04up);
  void e04unz(Boolean *unitq,  Integer *inform,
              Integer *majits, Integer m, Integer n, Integer nclin,
              Integer ncnln, Integer *nactiv, Integer *nfree, Integer *nz,
              Integer tdcj, Integer tdcju, Integer tdfj, Integer tdfju,
              Integer tdaqp, Integer tdr, Integer *nfun, Integer *ngrad,
              Integer istate[], Integer kactiv[], Integer kx[],
              double *objf, double *fdnorm, double *xnorm,
              NAG_E04UNC_CONFUN confun, NAG_E04UNC_OBJFUN objfun,  double aqp[],
              double ax[], double bl[], double bu[], double c[],
              double cjac[], double cjacu[], double clamda[],
              double y[], double f[], double fjac[],
              double fjacu[], double featol[], double grad[],
              double r[], double x[],  Integer iw[],  double w[],
              Nag_Deriv_Inf *diff, Nag_E04_Opt *opt, Nag_Comm *comm,
              Nag_FileSt *stream, Nag_Search_State *st, NagError *ovflow,
              Nag_ae04nc *ae04nc, Nag_ae04uc *ae04uc, Nag_ae04up *ae04up, 
              Nag_be04nb *be04nb, Nag_ce04nc *ce04nc, Nag_de04nb *de04nb, 
              Nag_de04uc *de04uc, Nag_ee04nb *ee04nb, Nag_fe04nb *fe04nb, 
              Nag_fe04uc *fe04uc, int *fail_code);
  void e04upg(Nag_Grad_Chk_St g_chk, Integer m, Integer n, double x[], 
              double fjac[], Integer tdfj, Integer ncnln, double cjac[], 
              Integer tdcj, const Nag_GPrintSt *gprint, Nag_FileSt *stream);
  void e04upq(Nag_DerivSet deriv_level,
              Integer m, Integer n, Integer tdfjac, Integer tdfjacu,
              double bigbnd, double epsrf, double oktol,
              double fdchk, double xnorm, NAG_E04UNC_OBJFUN objfun,
              double bl[], double bu[], double f[], double f1[],
              double fjac[], double fjacu[], double fjdx[],
              double dx[], double err[], double x[], double y[],
              Nag_Grad_Chk_St g_chk, Nag_Comm *comm, int *fj_error,
              Nag_GPrintSt *gprint);
  void e04upr(Nag_DerivSet *deriv_level, 
              Integer m, Integer n, Integer ncnln, Integer tdcj, Integer tdcju,
              Integer tdfj, Integer tdfju,  double bigbnd, double epsrf,
              double *fdnorm, NAG_E04UNC_CONFUN confun, NAG_E04UNC_OBJFUN objfun,
              Integer needc[],  double bl[], double bu[],
              double c[], double c1[], double c2[],
              double cjac[], double cjacu[], double f[],
              double f1[], double f2[], double fjac[],
              double fjacu[], double hforwd[], double hcntrl[],
              double x[], double y[], Nag_Deriv_Inf *diff, 
              Nag_Comm *comm, Nag_GPrintSt *gprint);
  void e04ups(Integer n, Integer tdzy, Integer nfree, Boolean unitq,
              Integer kx[], Integer m, double fjac[], Integer tdfj,
              double r[], Integer tdr, double zy[], double work[],
              NagError *fail_qdc);
  void e04upw(Boolean centrl, Integer tdcj, Integer tdcju,
              Integer tdfj, Integer tdfju, Integer m, Integer n, Integer ncnln,
              double bigbnd, double cdint, double fdint,
              double *fdnorm, NAG_E04UNC_CONFUN confun, NAG_E04UNC_OBJFUN objfun,
              Integer needc[], double bl[], double bu[], double c[], double c1[], 
              double c2[], double cjac[], double cjacu[], double f[], double f1[],
              double f2[], double fjac[], double fjacu[], double hforwd[], 
              double hcntrl[], double x[], Nag_Comm *comm, Nag_Deriv_Inf *diff);
  void e04upy(Nag_DerivSet *deriv_level,
              Integer *nfun, Integer *ngrad, Integer tdcjac, Integer tdcjacu,
              Integer tdfjac, Integer tdfjacu, Integer m, Integer n, Integer ncnln,
              NAG_E04UNC_CONFUN confun, NAG_E04UNC_OBJFUN objfun,
              Integer needc[], double bigbnd, 
              double epsrf, double cdint, double fdint, 
              double fdchk, double *fdnorm,     
              double xnorm, double bl[], double bu[], double c[],
              double c1[], double cjac[], double cjacu[], double cjdx[], 
              double f[], double f1[], double fjac[], double fjacu[], 
              double fjdx[], double dx[], double hforwd[], 
              double hcntrl[], double x[], double wrk1[], double wrk2[],
              double wrk4[], Nag_Comm *comm, Nag_Deriv_Inf *diff,
              Nag_Grad_Chk_St g_chk, int *error, Nag_GPrintSt *gprint);
  extern void e04uss   (Integer modefg, Integer * ierror, Integer nstate, Integer n,
                        Integer nncon, Integer nnjac, Integer nejac,
                        NAG_E04UGC_CONFUN fgcon,
                        Integer ne,
                        Integer nka, const Integer ha[], const Integer ka[], double fcon[],
                        double gcon[], double x[], Nag_Comm *comm,
                        char *cw, Integer lencw, Integer iw[], Integer leniw,
                        double rw[], Integer lenrw, Integer * modier);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04ust  (Boolean usefd, Integer *ierror, Integer n, Integer nnl,
                       Integer nb, Integer nejac, Integer nncon, Integer nnjac,
                       Integer nnobj, Integer nnobj0, 
                       void (*sfgcon)(Integer , Integer *, Integer , Integer ,
                                      Integer , Integer , Integer , 
                                      NAG_E04UGC_CONFUN fgcon,
                                      Integer ,
                                      Integer , const Integer [], const Integer [], double [],
                                      double [], double [], Nag_Comm *,
                                      char *cw, Integer , Integer [], Integer ,
                                      double [], Integer , Integer *),
                       NAG_E04UGC_CONFUN fgcon,
                       void (*sfgobj)(Integer , Integer *, Integer , Integer ,
                                      NAG_E04UGC_OBJFUN fgobj,
                                      double *, double [], double [], Nag_Comm *,
                                      char *cw, Integer , Integer [],
                                      Integer , double [], Integer , Integer *),
                       NAG_E04UGC_OBJFUN fgobj,
                       Integer ne, Integer nka, const Integer ha[], const Integer ka[],
                       double step, double gcon1[], double fcon2[], double gobj2[],
                       double x1[], double xdif[], double xfeas[], double w[],
                       Nag_Comm *comm, char *cw, Integer lencw,
                       Integer iw[], Integer leniw, double rw[], Integer lenrw,
                       Integer *modier);*/
    extern void e04ust  (Boolean usefd, Integer *ierror, Integer n, Integer nnl,
                       Integer nb, Integer nejac, Integer nncon, Integer nnjac,
                       Integer nnobj, Integer nnobj0, 
                       NAG_E04UST1_FUN sfgcon,
                       NAG_E04UGC_CONFUN fgcon,
                       NAG_E04UST2_FUN sfgobj,
                       NAG_E04UGC_OBJFUN fgobj,
                       Integer ne, Integer nka, const Integer ha[], const Integer ka[],
                       double step, double gcon1[], double fcon2[], double gobj2[],
                       double x1[], double xdif[], double xfeas[], double w[],
                       Nag_Comm *comm, char *cw, Integer lencw,
                       Integer iw[], Integer leniw, double rw[], Integer lenrw,
                       Integer *modier);
  extern void e04usu  (const char *job, Boolean *boostd, Integer itn, double gnorm,
                       double *wtinf, double wtinf0, double *weight, double *wtfac,
                       double *wtscal, const Integer iw[], Integer leniw, Nag_FileSt *stream);
  extern void e04usv  (Boolean elastc, Integer n, Integer nncon, double tolz,
                       double wtinf, const double bl[], const double bu[], double viol[],
                       double xs[], const double xmul[], const double xpen[], const double yslk[]);
  extern void e04usw  (Integer nb, double stepmx, double stepqp, double tolpiv,
                       double tolz, const double bl[], const double bu[], const double xs[],
                       const double xdif[], double *step);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void e04usx   (const char *start, Integer m, Integer n, Integer nb,
                        Integer ne, Integer nka, Integer iobj,
                        double objadd, double * flin, double * fobj, double * objtru,
                        Integer * ninf, double * sinf,
                        void (*sfgcon) (Integer, Integer *, Integer, Integer,
                                        Integer, Integer, Integer,
                                        NAG_E04UGC_CONFUN fgcon,
                                        Integer,
                                        Integer, const Integer[], const Integer[], double[],
                                        double[], double[], Nag_Comm *,
                                        char *cw, Integer, Integer[], Integer,
                                        double[], Integer, Integer *),
                        NAG_E04UGC_CONFUN fgcon,
                        void (*sfgobj) (Integer, Integer *, Integer, Integer,
                                        NAG_E04UGC_OBJFUN fgobj,
                                        double *, double[], double[], Nag_Comm *,
                                        char *cw, Integer, Integer[],
                                        Integer, double[], Integer, Integer *),
                        NAG_E04UGC_OBJFUN fgobj,
                        double a[], const Integer ha[], const Integer ka[], double bl[],
                        double bu[], char **names, Integer hs[], double xs[],
                        double pi[], double rc[], Integer * inform, Integer * nmajor,
                        Integer * ns, Nag_Comm *comm, char *cw,
                        Integer lencw, Integer iw[], Integer leniw, double rw[],
                        Integer lenrw, Boolean dummy, NagError *fail, Nag_FileSt *stream,
                        Boolean *print_deriv, Nag_E04_Opt *opt, Integer *modier,
                        double *duinf, Boolean ktcond[], Integer *nminor,
                        Integer *itn, Boolean *fp, Boolean *linfea, Integer *nstate,
                        Integer *ndegen);*/
  extern void e04usx   (const char *start, Integer m, Integer n, Integer nb,
                        Integer ne, Integer nka, Integer iobj,
                        double objadd, double * flin, double * fobj, double * objtru,
                        Integer * ninf, double * sinf,
                        NAG_E04USX1_FUN sfgcon,
                        NAG_E04UGC_CONFUN fgcon,
                        NAG_E04USX2_FUN sfgobj,
                        NAG_E04UGC_OBJFUN fgobj,
                        double a[], const Integer ha[], const Integer ka[], double bl[],
                        double bu[], char **names, Integer hs[], double xs[],
                        double dpi[], double rc[], Integer * inform, Integer * nmajor,
                        Integer * ns, Nag_Comm *comm, char *cw,
                        Integer lencw, Integer iw[], Integer leniw, double rw[],
                        Integer lenrw, Boolean dummy, NagError *fail, Nag_FileSt *stream,
                        Boolean *print_deriv, Nag_E04_Opt *opt, Integer *modier,
                        double *duinf, Boolean ktcond[], Integer *nminor,
                        Integer *itn, Boolean *fp, Boolean *linfea, Integer *nstate,
                        Integer *ndegen);
  extern void e04usy  (Integer nb, Integer nncon, Integer nnjac, Integer nejac,
                       double tolz, Integer ne, Integer nka, double a[],
                       const Integer ha[], const Integer ka[],
                       const double xs[], const Integer iw[],
                       Integer leniw, double rw[], Integer lenrw);
  extern void e04usz  (Integer nnobj, const double ascale[], double gobj[], const Integer iw[],
                       Integer leniw, const double rw[], Integer lenrw);
  extern NAG_DLL_EXPIMP void NAG_CALL 
  e04xac(Integer n, double x[], NAG_E04UCC_FUN objfun, double *objf, 
         double g[], double h_forward[], double h_central[],
         double h[], Integer tdh, Nag_DerivInfo deriv_info[],
         Nag_E04_Opt *options, Nag_Comm *comm, NagError *fail);
  extern void e04xap(Nag_Grad_Chk_St g_chk, Integer n, double x[], double grad[],
                     Integer ncnln, double cjac[], Integer tdcj,
                     const Nag_GPrintSt *gprint, Nag_FileSt *stream);
  extern void e04xaq(Nag_Grad_Chk_St g_chk, Integer n, double x[], double grad[],
                     Integer ncnln, double cjac[], Integer tdcj,
                     const Nag_GPrintSt *gprint, Nag_FileSt *stream);
  extern void e04xaw(Nag_DerivSet deriv_level,
                     Integer n, Integer ncnln, Integer tdcj,
                     Integer tdcju, double bigbnd, double epsrf,
                     double oktol, double fdchk, double xnorm,
                     NAG_E04UCC_CONFUN confun,
                     Integer needc[],
                     double bl[], double bu[], double c[], double c1[],
                     double cjac[], double cjacu[], double cjdx[],
                     double dx[], double err[], double x[], double y[],
                     Nag_Grad_Chk_St g_chk, const Nag_DebugSt *debug,
                     Nag_Comm *comm, int *j_error, Nag_GPrintSt *gprint);
  extern void e04xax(Integer n,
                     double bigbnd, double epsrf, double oktol,
                     double fdchk, double *objf, double xnorm,
                     NAG_E04UCC_FUN objfun,
                     double bl[], double bu[], double grad[], double gradu[],
                     double dx[], double x[], double y[],
                     Nag_Grad_Chk_St g_chk,
                     const Nag_DebugSt *debug, Nag_Comm *comm, int *g_error,
                     Nag_GPrintSt *gprint);
  extern void e04xay(Nag_DerivSet *deriv_level,
                     Integer n, Integer ncnln, Integer tdcj, Integer tdcju,
                     double bigbnd, double epsrf, double *fdnorm, double objf,
                     NAG_E04UCC_CONFUN confun, NAG_E04UCC_FUN objfun,
                     Integer needc[],
                     double bl[], double bu[], double c[], double c1[], double c2[],
                     double cjac[], double cjacu[], double grad[], double gradu[],
                     double hforwd[], double hcntrl[], double x[], double y[],
                     Nag_Deriv_Inf *diff, const Nag_DebugSt *debug, Nag_Comm *comm,
                     Nag_GPrintSt *gprint);
  extern void e04xaz(Boolean debug, Boolean *done, Boolean *first, double epsa,
                     double epsr, double fx, Integer *inform,
                     Integer *iter, Integer itmax, double *cdest,
                     double *fdest, double *sdest, double *errbnd,
                     double f1, double f2, double *h, double *hopt,
                     double *hphi, Nag_XazSt *st);
  extern Boolean e04xbp(Integer n, Integer ncnln, Nag_GPrintSt *gprint);
  Boolean e04xbq(Integer m, Integer n, Integer ncnln, Nag_GPrintSt *gprint);
  extern void e04xcp(Nag_GPrintSt *gprint);
  extern NAG_DLL_EXPIMP void NAG_CALL e04xxc(Nag_E04_Opt *opt);
  extern Boolean e04xxj(char str[], int nc, int *field_code);
  extern Boolean e04xxk(char str[], int nc, int *field_code);
  extern Boolean e04xxl(char str[], int nc, int *field_code);
  extern Boolean e04xxm(char str[], int nc, int *field_code);
  extern Boolean e04xxn(char str[], int nc, int *field_code);
  extern Boolean e04xxo(char str[], int nc, int *field_code);
  extern Boolean e04xxp(char str[], int nc, int *field_code);
  extern Boolean e04xxq(char str[], int nc, int *field_code);
  extern Boolean e04xxr(char str[], int nc, int *field_code);
  extern Boolean e04xxs(char str[], int nc, int *field_code);
  extern Boolean e04xxt(char str[], int nc, int *field_code);
  extern Boolean e04xxu(char str[], int nc, int *field_code);
  extern Boolean e04xxv(char str[], int nc, int *field_code);
  extern Boolean e04xxw(char str[], int nc, int *field_code);
  extern Boolean e04xxx(char str[], int nc, int *field_code);
  extern Boolean e04xxy(char str[], int nc, int *field_code);
  extern void e04xya(int field_code, Nag_E04_Opt *options, char buf[]);
  extern NAG_DLL_EXPIMP void NAG_CALL e04xyc(const char *name, 
                                             const char *opt_file, Nag_E04_Opt *opt,
                                             Boolean print, const char *outfile, NagError *fail);
  extern void e04xyj(int field_code, Nag_E04_Opt *options,
                     Nag_FileSt *stream, Nag_Mesg *mesg, NagError *fail);
  extern void e04xyk(int field_code, Nag_E04_Opt *options,
                     Nag_FileSt *stream, Nag_Mesg *mesg, NagError *fail);
  extern void e04xyl(int field_code, Nag_E04_Opt *options,
                     Nag_FileSt *stream, Nag_Mesg *mesg, NagError *fail);
  extern void e04xym(int field_code, Nag_E04_Opt *options,
                     Nag_FileSt *stream, Nag_Mesg *mesg, NagError *fail);
  extern void e04xyn(int field_code, Nag_E04_Opt *options,
                     Nag_FileSt *stream, Nag_Mesg *mesg, NagError *fail);
  extern void e04xyo(int field_code, Nag_E04_Opt *options,
                     Nag_FileSt *stream, Nag_Mesg *mesg, NagError *fail);
  extern void e04xyp(int field_code, Nag_E04_Opt *options,
                     Nag_FileSt *stream, Nag_Mesg *mesg, NagError *fail);
  extern void e04xyq(int field_code, Nag_E04_Opt *options,
                     Nag_FileSt *stream, Nag_Mesg *mesg, NagError *fail);
  extern void e04xyr(int field_code, Nag_E04_Opt *options,
                     Nag_FileSt *stream, Nag_Mesg *mesg, NagError *fail);
  extern void e04xys(int field_code, Nag_E04_Opt *options,
                     Nag_FileSt *stream, Nag_Mesg *mesg, NagError *fail);
  extern void e04xyt(int field_code, Nag_E04_Opt *options,
                     Nag_FileSt *stream, Nag_Mesg *mesg, NagError *fail);
  extern void e04xyu(int field_code, Nag_E04_Opt *options,
                     Nag_FileSt *stream, Nag_Mesg *mesg, NagError *fail);
  extern void e04xyv(int field_code, Nag_E04_Opt *options,
                     Nag_FileSt *stream, Nag_Mesg *mesg, NagError *fail);
  extern void e04xyw(int field_code, Nag_E04_Opt *options,
                     Nag_FileSt *stream, Nag_Mesg *mesg, NagError *fail);
  extern void e04xyx(int field_code, Nag_E04_Opt *options,
                     Nag_FileSt *stream, Nag_Mesg *mesg, NagError *fail);
  extern void e04xyy(int field_code, Nag_E04_Opt *options,
                     Nag_FileSt *stream, Nag_Mesg *mesg, NagError *fail);
  //Cheney 2006-6-5
  /*extern void e04xyz(Boolean (*valid_field)(char *str, int nc, int *field_code),
                     int *state, int *i, char line[], Integer *linenum,
                     int *field_code, FILE *fp, Nag_E04_Opt *opt, char str[],
                     Nag_Opt_Found *found);*/
  extern void e04xyz(NAG_E04XYZ_FUN valid_field,
                     int *state, int *i, char line[], Integer *linenum,
                     int *field_code, FILE *fp, Nag_E04_Opt *opt, char str[],
                     Nag_Opt_Found *found);
  extern NAG_DLL_EXPIMP void NAG_CALL e04xzc(Nag_E04_Opt *opt, const char *name, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL e04yac(Integer m, Integer n, NAG_E04YAC_FUN lsqfun,
                                             double x[], double fvec[], double fjac[], Integer tdj,
                                             Nag_Comm *user_comm, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL e04ycc(Integer job, Integer m, Integer n, double fsumsq,
                                             double cj[], Nag_E04_Opt *options, NagError *fail);
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGE04 */
